/*
 * Decompiled with CFR 0.152.
 */
package org.limitedlives.limitedLives;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.configuration.file.YamlConfiguration;
import org.limitedlives.limitedLives.LimitedLives;

public class DataHandler {
    private File dataFile;
    private YamlConfiguration dataConfig;
    private final Map<UUID, Integer> playerLives = new HashMap<UUID, Integer>();
    private LimitedLives plugin;

    public DataHandler(LimitedLives plugin) {
        this.dataFile = new File(plugin.getDataFolder(), "data.yml");
        this.dataConfig = YamlConfiguration.loadConfiguration((File)this.dataFile);
        this.plugin = plugin;
    }

    public void setLives(UUID uuid, int lives) {
        this.dataConfig.set(uuid.toString(), (Object)lives);
    }

    public Map<UUID, Integer> getLives() {
        return this.playerLives;
    }

    public void save() throws IOException {
        for (Map.Entry<UUID, Integer> entry : this.playerLives.entrySet()) {
            this.setLives(entry.getKey(), entry.getValue());
        }
        this.dataConfig.save(this.dataFile);
    }

    public void load(int defaultLives) {
        for (String key : this.dataConfig.getKeys(false)) {
            UUID uuid = UUID.fromString(key);
            int lives = this.dataConfig.getInt(key, defaultLives);
            this.playerLives.put(uuid, lives);
        }
        this.plugin.setInitialLives(this.plugin.getConfig().getInt("initialLives", 3));
        this.plugin.setResourceType(this.plugin.getConfig().getString("resourceType", "DIAMOND"));
        this.plugin.setResourceValue(this.plugin.getConfig().getInt("resourceValue", 10));
    }
}

