/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluenbt.adapter;

import de.bluecolored.bluenbt.BlueNBT;
import de.bluecolored.bluenbt.NBTReader;
import de.bluecolored.bluenbt.TagType;
import de.bluecolored.bluenbt.TypeDeserializer;
import de.bluecolored.bluenbt.TypeDeserializerFactory;
import de.bluecolored.bluenbt.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class PrimitiveDeserializerFactory
implements TypeDeserializerFactory {
    public static final PrimitiveDeserializerFactory INSTANCE = new PrimitiveDeserializerFactory();
    private static final Map<Type, TypeDeserializer<?>> TYPE_DESERIALIZER_MAP = new HashMap();

    private static void registerTypeDeserializer(Type primitiveType, Type boxedType, TypeDeserializer<?> typeDeserializer) {
        TYPE_DESERIALIZER_MAP.put(primitiveType, typeDeserializer);
        if (boxedType != null) {
            TYPE_DESERIALIZER_MAP.put(boxedType, typeDeserializer);
        }
    }

    public <T> Optional<TypeDeserializer<T>> create(TypeToken<T> typeToken, BlueNBT blueNBT) {
        TypeDeserializer<?> typeDeserializer = TYPE_DESERIALIZER_MAP.get(typeToken.getRawType());
        return Optional.ofNullable(typeDeserializer);
    }

    public static boolean readBool(NBTReader reader) throws IOException {
        TagType type = reader.peek();
        return switch (type) {
            case TagType.BYTE -> {
                if (reader.nextByte() != 0) {
                    yield true;
                }
                yield false;
            }
            case TagType.SHORT -> {
                if (reader.nextShort() != 0) {
                    yield true;
                }
                yield false;
            }
            case TagType.INT -> {
                if (reader.nextInt() != 0) {
                    yield true;
                }
                yield false;
            }
            case TagType.LONG -> {
                if (reader.nextLong() != 0L) {
                    yield true;
                }
                yield false;
            }
            case TagType.FLOAT -> {
                if (reader.nextFloat() != 0.0f) {
                    yield true;
                }
                yield false;
            }
            case TagType.DOUBLE -> {
                if (reader.nextDouble() != 0.0) {
                    yield true;
                }
                yield false;
            }
            case TagType.STRING -> Boolean.parseBoolean(reader.nextString());
            default -> throw new IllegalStateException("STRING or any number tag expected but got " + String.valueOf((Object)type) + ". At: " + reader.path());
        };
    }

    public static byte readByte(NBTReader reader) throws IOException {
        TagType type = reader.peek();
        return switch (type) {
            case TagType.BYTE -> reader.nextByte();
            case TagType.SHORT -> (byte)reader.nextShort();
            case TagType.INT -> (byte)reader.nextInt();
            case TagType.LONG -> (byte)reader.nextLong();
            case TagType.FLOAT -> (byte)reader.nextFloat();
            case TagType.DOUBLE -> (byte)reader.nextDouble();
            case TagType.STRING -> Byte.parseByte(reader.nextString());
            default -> throw new IllegalStateException("BYTE tag expected but got " + String.valueOf((Object)type) + ". At: " + reader.path());
        };
    }

    public static short readShort(NBTReader reader) throws IOException {
        TagType type = reader.peek();
        return switch (type) {
            case TagType.BYTE -> reader.nextByte();
            case TagType.SHORT -> reader.nextShort();
            case TagType.INT -> (short)reader.nextInt();
            case TagType.LONG -> (short)reader.nextLong();
            case TagType.FLOAT -> (short)reader.nextFloat();
            case TagType.DOUBLE -> (short)reader.nextDouble();
            case TagType.STRING -> Short.parseShort(reader.nextString());
            default -> throw new IllegalStateException("SHORT tag expected but got " + String.valueOf((Object)type) + ". At: " + reader.path());
        };
    }

    public static char readChar(NBTReader reader) throws IOException {
        TagType type = reader.peek();
        return switch (type) {
            case TagType.BYTE -> (char)reader.nextByte();
            case TagType.SHORT -> (char)reader.nextShort();
            case TagType.INT -> (char)reader.nextInt();
            case TagType.LONG -> (char)reader.nextLong();
            case TagType.FLOAT -> (char)reader.nextFloat();
            case TagType.DOUBLE -> (char)reader.nextDouble();
            case TagType.STRING -> {
                String string = reader.nextString();
                if (string.length() != 1) {
                    throw new IllegalStateException("Can not parse char from string '" + string + "'");
                }
                yield string.charAt(0);
            }
            default -> throw new IllegalStateException("Any number tag expected but got " + String.valueOf((Object)type) + ". At: " + reader.path());
        };
    }

    public static int readInt(NBTReader reader) throws IOException {
        TagType type = reader.peek();
        return switch (type) {
            case TagType.BYTE -> reader.nextByte();
            case TagType.SHORT -> reader.nextShort();
            case TagType.INT -> reader.nextInt();
            case TagType.LONG -> (int)reader.nextLong();
            case TagType.FLOAT -> (int)reader.nextFloat();
            case TagType.DOUBLE -> (int)reader.nextDouble();
            case TagType.STRING -> Integer.parseInt(reader.nextString());
            default -> throw new IllegalStateException("INT tag expected but got " + String.valueOf((Object)type) + ". At: " + reader.path());
        };
    }

    public static long readLong(NBTReader reader) throws IOException {
        TagType type = reader.peek();
        return switch (type) {
            case TagType.LONG -> reader.nextLong();
            case TagType.BYTE -> reader.nextByte();
            case TagType.SHORT -> reader.nextShort();
            case TagType.INT -> reader.nextInt();
            case TagType.FLOAT -> (long)reader.nextFloat();
            case TagType.DOUBLE -> (long)reader.nextDouble();
            case TagType.STRING -> Long.parseLong(reader.nextString());
            default -> throw new IllegalStateException("LONG tag expected but got " + String.valueOf((Object)type) + ". At: " + reader.path());
        };
    }

    public static float readFloat(NBTReader reader) throws IOException {
        TagType type = reader.peek();
        return switch (type) {
            case TagType.FLOAT -> reader.nextFloat();
            case TagType.BYTE -> reader.nextByte();
            case TagType.SHORT -> reader.nextShort();
            case TagType.INT -> reader.nextInt();
            case TagType.LONG -> reader.nextLong();
            case TagType.DOUBLE -> (float)reader.nextDouble();
            case TagType.STRING -> Float.parseFloat(reader.nextString());
            default -> throw new IllegalStateException("FLOAT tag expected but got " + String.valueOf((Object)type) + ". At: " + reader.path());
        };
    }

    public static double readDouble(NBTReader reader) throws IOException {
        TagType type = reader.peek();
        return switch (type) {
            case TagType.DOUBLE -> reader.nextDouble();
            case TagType.BYTE -> reader.nextByte();
            case TagType.SHORT -> reader.nextShort();
            case TagType.INT -> reader.nextInt();
            case TagType.LONG -> reader.nextLong();
            case TagType.FLOAT -> reader.nextFloat();
            case TagType.STRING -> Double.parseDouble(reader.nextString());
            default -> throw new IllegalStateException("DOUBLE tag expected but got " + String.valueOf((Object)type) + ". At: " + reader.path());
        };
    }

    public static String readString(NBTReader reader) throws IOException {
        TagType type = reader.peek();
        return switch (type) {
            case TagType.STRING -> reader.nextString();
            case TagType.BYTE -> String.valueOf(reader.nextByte());
            case TagType.SHORT -> String.valueOf(reader.nextShort());
            case TagType.INT -> String.valueOf(reader.nextInt());
            case TagType.LONG -> String.valueOf(reader.nextLong());
            case TagType.FLOAT -> String.valueOf(reader.nextFloat());
            case TagType.DOUBLE -> String.valueOf(reader.nextDouble());
            default -> throw new IllegalStateException("STRING tag expected but got " + String.valueOf((Object)type) + ". At: " + reader.path());
        };
    }

    static {
        PrimitiveDeserializerFactory.registerTypeDeserializer(Boolean.TYPE, Boolean.class, PrimitiveDeserializerFactory::readBool);
        PrimitiveDeserializerFactory.registerTypeDeserializer(Byte.TYPE, Byte.class, PrimitiveDeserializerFactory::readByte);
        PrimitiveDeserializerFactory.registerTypeDeserializer(Short.TYPE, Short.class, PrimitiveDeserializerFactory::readShort);
        PrimitiveDeserializerFactory.registerTypeDeserializer(Character.TYPE, Character.class, PrimitiveDeserializerFactory::readChar);
        PrimitiveDeserializerFactory.registerTypeDeserializer(Integer.TYPE, Integer.class, PrimitiveDeserializerFactory::readInt);
        PrimitiveDeserializerFactory.registerTypeDeserializer(Long.TYPE, Long.class, PrimitiveDeserializerFactory::readLong);
        PrimitiveDeserializerFactory.registerTypeDeserializer(Float.TYPE, Float.class, PrimitiveDeserializerFactory::readFloat);
        PrimitiveDeserializerFactory.registerTypeDeserializer(Double.TYPE, Double.class, PrimitiveDeserializerFactory::readDouble);
        PrimitiveDeserializerFactory.registerTypeDeserializer(String.class, null, PrimitiveDeserializerFactory::readString);
    }
}

