/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluenbt.adapter;

import de.bluecolored.bluenbt.BlueNBT;
import de.bluecolored.bluenbt.InstanceCreator;
import de.bluecolored.bluenbt.NBTAdapter;
import de.bluecolored.bluenbt.NBTDeserializer;
import de.bluecolored.bluenbt.NBTName;
import de.bluecolored.bluenbt.NBTPostDeserialize;
import de.bluecolored.bluenbt.NBTReader;
import de.bluecolored.bluenbt.TagType;
import de.bluecolored.bluenbt.TypeDeserializer;
import de.bluecolored.bluenbt.TypeDeserializerFactory;
import de.bluecolored.bluenbt.TypeResolver;
import de.bluecolored.bluenbt.TypeToken;
import de.bluecolored.bluenbt.adapter.PrimitiveDeserializerFactory;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public class DefaultDeserializerFactory
implements TypeDeserializerFactory {
    public static final DefaultDeserializerFactory INSTANCE = new DefaultDeserializerFactory();

    public <T> Optional<TypeDeserializer<T>> create(TypeToken<T> type, BlueNBT blueNBT) {
        return Optional.of(this.createFor(type, blueNBT));
    }

    public <T> TypeDeserializer<T> createFor(TypeToken<T> type, BlueNBT blueNBT) {
        try {
            TypeResolver<T, ?> typeResolver = blueNBT.getTypeResolver(type);
            if (typeResolver != null) {
                return new TypeResolvingAdapter<T>(type, typeResolver, blueNBT);
            }
            return new DefaultAdapter<T>(type, blueNBT);
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to create Default-TypeSerializer for type: " + String.valueOf(type), ex);
        }
    }

    static class TypeResolvingAdapter<T>
    implements TypeDeserializer<T> {
        private final TypeResolver<T, Object> typeResolver;
        private final TypeToken<Object> baseType;
        private final TypeDeserializer<Object> baseDeserializer;
        private final Map<TypeToken<?>, TypeDeserializer<? extends T>> delegateDeserializers;
        private final TypeDeserializer<T> fallbackDeserializer;

        public TypeResolvingAdapter(TypeToken<T> type, TypeResolver<T, ?> typeResolver, BlueNBT blueNBT) {
            this.typeResolver = typeResolver;
            this.baseType = this.typeResolver.getBaseType();
            this.baseDeserializer = this.baseType.equals(type) ? new DefaultAdapter<Object>(this.baseType, blueNBT) : blueNBT.getTypeDeserializer(this.baseType);
            this.delegateDeserializers = new HashMap();
            for (TypeToken<T> resolved : typeResolver.getPossibleTypes()) {
                this.delegateDeserializers.put(resolved, resolved.equals(type) ? new DefaultAdapter<T>(resolved, blueNBT) : blueNBT.getTypeDeserializer(resolved));
            }
            this.fallbackDeserializer = new DefaultAdapter<T>(type, blueNBT);
        }

        /*
         * Exception decompiling
         */
        @Override
        public T read(NBTReader reader) throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    static class DefaultAdapter<T>
    implements TypeDeserializer<T> {
        private static final Map<Type, Function<Field, FieldAccessor>> SPECIAL_ACCESSORS = Map.of(Boolean.TYPE, field -> (object, reader) -> field.setBoolean(object, PrimitiveDeserializerFactory.readBool(reader)), Byte.TYPE, field -> (object, reader) -> field.setByte(object, PrimitiveDeserializerFactory.readByte(reader)), Short.TYPE, field -> (object, reader) -> field.setShort(object, PrimitiveDeserializerFactory.readShort(reader)), Character.TYPE, field -> (object, reader) -> field.setChar(object, PrimitiveDeserializerFactory.readChar(reader)), Integer.TYPE, field -> (object, reader) -> field.setInt(object, PrimitiveDeserializerFactory.readInt(reader)), Long.TYPE, field -> (object, reader) -> field.setLong(object, PrimitiveDeserializerFactory.readLong(reader)), Float.TYPE, field -> (object, reader) -> field.setFloat(object, PrimitiveDeserializerFactory.readFloat(reader)), Double.TYPE, field -> (object, reader) -> field.setDouble(object, PrimitiveDeserializerFactory.readDouble(reader)));
        private final TypeToken<T> type;
        private final InstanceCreator<T> constructor;
        private final Map<String, FieldAccessor> fields = new HashMap<String, FieldAccessor>();
        private final Collection<PostSerializeAction<T>> postSerializeActions = new ArrayList<PostSerializeAction<T>>(0);

        public DefaultAdapter(TypeToken<T> type, BlueNBT blueNBT) {
            Class<T> raw;
            this.type = type;
            this.constructor = blueNBT.getInstanceCreator(type);
            HashMap<Class, TypeDeserializer> typeDeserializerCache = new HashMap<Class, TypeDeserializer>();
            TypeToken<Object> typeToken = type;
            while (typeToken != null && (raw = typeToken.getRawType()) != Object.class) {
                for (Field field : raw.getDeclaredFields()) {
                    FieldAccessor accessor;
                    TypeDeserializer<?> typeDeserializer;
                    TypeToken<?> fieldType;
                    Class<TypeDeserializer<?>> deserializerType;
                    int modifiers = field.getModifiers();
                    if (Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers)) continue;
                    field.setAccessible(true);
                    String[] names = new String[]{blueNBT.getNamingStrategy().apply(field)};
                    NBTName nbtName = field.getAnnotation(NBTName.class);
                    if (nbtName != null && nbtName.value().length > 0) {
                        names = nbtName.value();
                    }
                    if ((deserializerType = this.findDeserializerType(field, (fieldType = TypeToken.of(typeToken.resolve(field.getGenericType()))).getRawType())) != null) {
                        typeDeserializer = typeDeserializerCache.computeIfAbsent(deserializerType, t2 -> this.createTypeDeserializerInstance((Class<? extends TypeDeserializer<?>>)t2, fieldType, blueNBT));
                    } else {
                        if (SPECIAL_ACCESSORS.containsKey(fieldType.getType())) {
                            accessor = SPECIAL_ACCESSORS.get(fieldType.getType()).apply(field);
                            for (String name : names) {
                                this.fields.put(name, accessor);
                            }
                            continue;
                        }
                        typeDeserializer = blueNBT.getTypeDeserializer(fieldType);
                    }
                    accessor = new TypeDeserializerFieldAccessor(field, typeDeserializer);
                    for (String name : names) {
                        this.fields.put(name, accessor);
                    }
                }
                for (AccessibleObject accessibleObject : raw.getDeclaredMethods()) {
                    if (((Method)accessibleObject).getAnnotation(NBTPostDeserialize.class) == null || ((Method)accessibleObject).getParameterCount() != 0) continue;
                    ((Method)accessibleObject).setAccessible(true);
                    this.postSerializeActions.add(arg_0 -> DefaultAdapter.lambda$new$17((Method)accessibleObject, arg_0));
                }
                Type superType = typeToken.resolve(raw.getGenericSuperclass());
                typeToken = superType != null ? TypeToken.of(superType) : null;
            }
        }

        @Override
        public T read(NBTReader reader) throws IOException {
            try {
                T object = this.constructor.create();
                reader.beginCompound();
                while (reader.peek() != TagType.END) {
                    String name = reader.name();
                    FieldAccessor fieldInfo = this.fields.get(name);
                    if (fieldInfo != null) {
                        fieldInfo.read(object, reader);
                        continue;
                    }
                    reader.skip();
                }
                reader.endCompound();
                if (!this.postSerializeActions.isEmpty()) {
                    for (PostSerializeAction<T> action : this.postSerializeActions) {
                        action.invoke(object);
                    }
                }
                return object;
            }
            catch (IllegalAccessException | InvocationTargetException ex) {
                throw new IOException("Failed to create instance of type '" + String.valueOf(this.type) + "'!", ex);
            }
        }

        @Nullable
        private Class<? extends TypeDeserializer<?>> findDeserializerType(Field field, Class<?> type) {
            NBTDeserializer fieldDeserializer = field.getAnnotation(NBTDeserializer.class);
            if (fieldDeserializer != null) {
                return fieldDeserializer.value();
            }
            NBTAdapter fieldAdapter = field.getAnnotation(NBTAdapter.class);
            if (fieldAdapter != null) {
                return fieldAdapter.value();
            }
            NBTDeserializer typeDeserializer = type.getAnnotation(NBTDeserializer.class);
            if (typeDeserializer != null) {
                return typeDeserializer.value();
            }
            NBTAdapter typeAdapter = type.getAnnotation(NBTAdapter.class);
            if (typeAdapter != null) {
                return typeAdapter.value();
            }
            return null;
        }

        private TypeDeserializer<?> createTypeDeserializerInstance(Class<? extends TypeDeserializer<?>> deserializerType, TypeToken<?> fieldType, BlueNBT blueNBT) {
            try {
                try {
                    return this.callConstructor(deserializerType.getDeclaredConstructor(TypeToken.class, BlueNBT.class), fieldType, blueNBT);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    try {
                        return this.callConstructor(deserializerType.getDeclaredConstructor(TypeToken.class), fieldType);
                    }
                    catch (NoSuchMethodException noSuchMethodException2) {
                        try {
                            return this.callConstructor(deserializerType.getDeclaredConstructor(BlueNBT.class), blueNBT);
                        }
                        catch (NoSuchMethodException noSuchMethodException3) {
                            return this.callConstructor(deserializerType.getDeclaredConstructor(new Class[0]), new Object[0]);
                        }
                    }
                }
            }
            catch (ReflectiveOperationException ex) {
                throw new IllegalStateException("Failed to create instance of TypeDeserializer: " + String.valueOf(deserializerType), ex);
            }
        }

        private <U> U callConstructor(Constructor<U> constructor, Object ... args) throws ReflectiveOperationException {
            constructor.setAccessible(true);
            return constructor.newInstance(args);
        }

        private static /* synthetic */ void lambda$new$17(Method rec$, Object x$0) throws IOException, IllegalAccessException, InvocationTargetException {
            rec$.invoke(x$0, new Object[0]);
        }
    }

    private static class TypeDeserializerFieldAccessor
    implements FieldAccessor {
        private final Field field;
        private final TypeDeserializer<?> typeDeserializer;

        @Override
        public void read(Object object, NBTReader reader) throws IOException, IllegalAccessException {
            this.field.set(object, this.typeDeserializer.read(reader));
        }

        public TypeDeserializerFieldAccessor(Field field, TypeDeserializer<?> typeDeserializer) {
            this.field = field;
            this.typeDeserializer = typeDeserializer;
        }
    }

    @FunctionalInterface
    private static interface PostSerializeAction<T> {
        public void invoke(T var1) throws IOException, IllegalAccessException, InvocationTargetException;
    }

    @FunctionalInterface
    private static interface FieldAccessor {
        public void read(Object var1, NBTReader var2) throws IOException, IllegalAccessException;
    }
}

