/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.world.mca.data;

import de.bluecolored.bluenbt.NBTReader;
import de.bluecolored.bluenbt.TagType;
import de.bluecolored.bluenbt.TypeDeserializer;
import java.io.IOException;
import java.util.UUID;

public class UUIDDeserializer
implements TypeDeserializer<UUID> {
    @Override
    public UUID read(NBTReader reader) throws IOException {
        TagType tagType = reader.peek();
        if (tagType == TagType.STRING) {
            return UUID.fromString(reader.nextString());
        }
        if (tagType == TagType.INT_ARRAY) {
            int[] ints = reader.nextIntArray();
            if (ints.length != 4) {
                throw new IOException("Unexpected number of UUID-ints, expected 4, got " + ints.length);
            }
            return new UUID((long)ints[0] << 32 | (long)ints[1], (long)ints[2] << 32 | (long)ints[3]);
        }
        long[] longs = reader.nextLongArray();
        if (longs.length != 2) {
            throw new IOException("Unexpected number of UUID-longs, expected 2, got " + longs.length);
        }
        return new UUID(longs[0], longs[1]);
    }
}

