/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.util.math;

import com.flowpowered.math.vector.Vector3i;
import de.bluecolored.bluemap.core.util.math.MatrixM3f;
import de.bluecolored.bluemap.core.util.math.MatrixM4f;

public class VectorM3f {
    public float x;
    public float y;
    public float z;

    public VectorM3f(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public VectorM3f set(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public VectorM3f set(Vector3i v) {
        this.x = v.getX();
        this.y = v.getY();
        this.z = v.getZ();
        return this;
    }

    public VectorM3f set(VectorM3f v) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
        return this;
    }

    public VectorM3f mul(float a) {
        this.x *= a;
        this.y *= a;
        this.z *= a;
        return this;
    }

    public VectorM3f cross(VectorM3f v) {
        return this.set(this.y * v.z - this.z * v.y, this.z * v.x - this.x * v.z, this.x * v.y - this.y * v.x);
    }

    public VectorM3f transform(MatrixM3f t2) {
        return this.set(t2.m00 * this.x + t2.m01 * this.y + t2.m02 * this.z, t2.m10 * this.x + t2.m11 * this.y + t2.m12 * this.z, t2.m20 * this.x + t2.m21 * this.y + t2.m22 * this.z);
    }

    public VectorM3f transform(MatrixM4f t2) {
        return this.set(t2.m00 * this.x + t2.m01 * this.y + t2.m02 * this.z + t2.m03, t2.m10 * this.x + t2.m11 * this.y + t2.m12 * this.z + t2.m13, t2.m20 * this.x + t2.m21 * this.y + t2.m22 * this.z + t2.m23);
    }

    public VectorM3f rotateAndScale(MatrixM4f t2) {
        return this.set(t2.m00 * this.x + t2.m01 * this.y + t2.m02 * this.z, t2.m10 * this.x + t2.m11 * this.y + t2.m12 * this.z, t2.m20 * this.x + t2.m21 * this.y + t2.m22 * this.z);
    }

    public VectorM3f normalize() {
        float length = this.length();
        this.x /= length;
        this.y /= length;
        this.z /= length;
        return this;
    }

    public VectorM3f absolute() {
        this.x = Math.abs(this.x);
        this.y = Math.abs(this.y);
        this.z = Math.abs(this.z);
        return this;
    }

    public float length() {
        return (float)Math.sqrt(this.lengthSquared());
    }

    public double lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public float dot(VectorM3f v) {
        return this.x * v.x + this.y * v.y + this.z * v.z;
    }

    public float max() {
        return Math.max(this.x, Math.max(this.y, this.z));
    }

    public float min() {
        return Math.min(this.x, Math.min(this.y, this.z));
    }
}

