/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.storage.sql.commandset;

import de.bluecolored.bluemap.core.logger.Logger;
import de.bluecolored.bluemap.core.storage.compression.Compression;
import de.bluecolored.bluemap.core.storage.sql.Database;
import de.bluecolored.bluemap.core.storage.sql.commandset.CommandSet;
import de.bluecolored.bluemap.core.util.Caches;
import de.bluecolored.bluemap.core.util.Key;
import de.bluecolored.shadow.caffeine.cache.LoadingCache;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCommandSet
implements CommandSet {
    protected final Database db;
    protected final LoadingCache<String, Integer> mapKeys = Caches.build(this::findOrCreateMapKey);
    protected final LoadingCache<Compression, Integer> compressionKeys = Caches.build(this::findOrCreateCompressionKey);
    protected final LoadingCache<Key, Integer> itemStorageKeys = Caches.build(this::findOrCreateItemStorageKey);
    protected final LoadingCache<Key, Integer> gridStorageKeys = Caches.build(this::findOrCreateGridStorageKey);

    @Language(value="sql")
    public abstract String listExistingTablesStatement();

    @Language(value="sql")
    public abstract String createMapTableStatement();

    @Language(value="sql")
    public abstract String createCompressionTableStatement();

    @Language(value="sql")
    public abstract String createItemStorageTableStatement();

    @Language(value="sql")
    public abstract String createItemStorageDataTableStatement();

    @Language(value="sql")
    public abstract String createGridStorageTableStatement();

    @Language(value="sql")
    public abstract String createGridStorageDataTableStatement();

    @Override
    public void initializeTables() throws IOException {
        this.db.run(connection -> {
            try {
                HashSet<String> tables = new HashSet<String>(6);
                ResultSet result = AbstractCommandSet.executeQuery(connection, this.listExistingTablesStatement(), new Object[0]);
                while (result.next()) {
                    tables.add(result.getString(1));
                }
                if (tables.containsAll(Set.of("bluemap_map", "bluemap_compression", "bluemap_item_storage", "bluemap_item_storage_data", "bluemap_grid_storage", "bluemap_grid_storage_data"))) {
                    return;
                }
            }
            catch (SQLException ex) {
                Logger.global.logWarning("Failed to check for existing tables, will try to create them...");
                Logger.global.logDebug(ex.toString());
            }
            AbstractCommandSet.executeUpdate(connection, this.createMapTableStatement(), new Object[0]);
            AbstractCommandSet.executeUpdate(connection, this.createCompressionTableStatement(), new Object[0]);
            AbstractCommandSet.executeUpdate(connection, this.createItemStorageTableStatement(), new Object[0]);
            AbstractCommandSet.executeUpdate(connection, this.createItemStorageDataTableStatement(), new Object[0]);
            AbstractCommandSet.executeUpdate(connection, this.createGridStorageTableStatement(), new Object[0]);
            AbstractCommandSet.executeUpdate(connection, this.createGridStorageDataTableStatement(), new Object[0]);
        });
    }

    @Language(value="sql")
    public abstract String itemStorageWriteStatement();

    @Override
    public void writeItem(String mapId, Key key, Compression compression, byte[] bytes) throws IOException {
        int mapKey = this.mapKey(mapId);
        int storageKey = this.itemStorageKey(key);
        int compressionKey = this.compressionKey(compression);
        this.db.run(connection -> AbstractCommandSet.executeUpdate(connection, this.itemStorageWriteStatement(), mapKey, storageKey, compressionKey, bytes));
    }

    @Language(value="sql")
    public abstract String itemStorageReadStatement();

    @Override
    public byte @Nullable [] readItem(String mapId, Key key, Compression compression) throws IOException {
        int mapKey = this.mapKey(mapId);
        int storageKey = this.itemStorageKey(key);
        int compressionKey = this.compressionKey(compression);
        return this.db.run(connection -> {
            ResultSet result = AbstractCommandSet.executeQuery(connection, this.itemStorageReadStatement(), mapKey, storageKey, compressionKey);
            if (!result.next()) {
                return null;
            }
            return result.getBytes(1);
        });
    }

    @Language(value="sql")
    public abstract String itemStorageDeleteStatement();

    @Override
    public void deleteItem(String mapId, Key key) throws IOException {
        int mapKey = this.mapKey(mapId);
        int storageKey = this.itemStorageKey(key);
        this.db.run(connection -> AbstractCommandSet.executeUpdate(connection, this.itemStorageDeleteStatement(), mapKey, storageKey));
    }

    @Language(value="sql")
    public abstract String itemStorageHasStatement();

    @Override
    public boolean hasItem(String mapId, Key key, Compression compression) throws IOException {
        int mapKey = this.mapKey(mapId);
        int storageKey = this.itemStorageKey(key);
        int compressionKey = this.compressionKey(compression);
        return this.db.run(connection -> {
            ResultSet result = AbstractCommandSet.executeQuery(connection, this.itemStorageHasStatement(), mapKey, storageKey, compressionKey);
            if (!result.next()) {
                throw new IllegalStateException("Counting query returned empty result!");
            }
            return result.getBoolean(1);
        });
    }

    @Language(value="sql")
    public abstract String gridStorageWriteStatement();

    @Override
    public void writeGridItem(String mapId, Key key, int x, int z, Compression compression, byte[] bytes) throws IOException {
        int mapKey = this.mapKey(mapId);
        int storageKey = this.gridStorageKey(key);
        int compressionKey = this.compressionKey(compression);
        this.db.run(connection -> AbstractCommandSet.executeUpdate(connection, this.gridStorageWriteStatement(), mapKey, storageKey, x, z, compressionKey, bytes));
    }

    @Language(value="sql")
    public abstract String gridStorageReadStatement();

    @Override
    public byte @Nullable [] readGridItem(String mapId, Key key, int x, int z, Compression compression) throws IOException {
        int mapKey = this.mapKey(mapId);
        int storageKey = this.gridStorageKey(key);
        int compressionKey = this.compressionKey(compression);
        return this.db.run(connection -> {
            ResultSet result = AbstractCommandSet.executeQuery(connection, this.gridStorageReadStatement(), mapKey, storageKey, x, z, compressionKey);
            if (!result.next()) {
                return null;
            }
            return result.getBytes(1);
        });
    }

    @Language(value="sql")
    public abstract String gridStorageDeleteStatement();

    @Override
    public void deleteGridItem(String mapId, Key key, int x, int z) throws IOException {
        int mapKey = this.mapKey(mapId);
        int storageKey = this.gridStorageKey(key);
        this.db.run(connection -> AbstractCommandSet.executeUpdate(connection, this.gridStorageDeleteStatement(), mapKey, storageKey, x, z));
    }

    @Language(value="sql")
    public abstract String gridStorageHasStatement();

    @Override
    public boolean hasGridItem(String mapId, Key key, int x, int z, Compression compression) throws IOException {
        int mapKey = this.mapKey(mapId);
        int storageKey = this.gridStorageKey(key);
        int compressionKey = this.compressionKey(compression);
        return this.db.run(connection -> {
            ResultSet result = AbstractCommandSet.executeQuery(connection, this.gridStorageHasStatement(), mapKey, storageKey, x, z, compressionKey);
            if (!result.next()) {
                throw new IllegalStateException("Counting query returned empty result!");
            }
            return result.getBoolean(1);
        });
    }

    @Language(value="sql")
    public abstract String gridStorageListStatement();

    @Override
    public CommandSet.TilePosition[] listGridItems(String mapId, Key key, Compression compression, int start, int count) throws IOException {
        int mapKey = this.mapKey(mapId);
        int storageKey = this.gridStorageKey(key);
        int compressionKey = this.compressionKey(compression);
        return this.db.run(connection -> {
            ResultSet result = AbstractCommandSet.executeQuery(connection, this.gridStorageListStatement(), mapKey, storageKey, compressionKey, count, start);
            CommandSet.TilePosition[] tiles = new CommandSet.TilePosition[count];
            int i = 0;
            while (result.next()) {
                tiles[i++] = new CommandSet.TilePosition(result.getInt(1), result.getInt(2));
            }
            if (i < count) {
                CommandSet.TilePosition[] trimmed = new CommandSet.TilePosition[i];
                System.arraycopy(tiles, 0, trimmed, 0, i);
                tiles = trimmed;
            }
            return tiles;
        });
    }

    @Language(value="sql")
    public abstract String gridStorageCountMapItemsStatement();

    @Override
    public int countMapGridsItems(String mapId) throws IOException {
        int mapKey = this.mapKey(mapId);
        return this.db.run(connection -> {
            ResultSet result = AbstractCommandSet.executeQuery(connection, this.gridStorageCountMapItemsStatement(), mapKey);
            if (!result.next()) {
                throw new IllegalStateException("Counting query returned empty result!");
            }
            return result.getInt(1);
        });
    }

    @Language(value="sql")
    public abstract String gridStoragePurgeMapStatement();

    @Override
    public int purgeMapGrids(String mapId, int limit) throws IOException {
        int mapKey = this.mapKey(mapId);
        return this.db.run(connection -> AbstractCommandSet.executeUpdate(connection, this.gridStoragePurgeMapStatement(), mapKey, limit));
    }

    @Language(value="sql")
    public abstract String purgeMapStatement();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void purgeMap(String mapId) throws IOException {
        LoadingCache<String, Integer> loadingCache = this.mapKeys;
        synchronized (loadingCache) {
            int mapKey = this.mapKey(mapId);
            this.db.run(connection -> AbstractCommandSet.executeUpdate(connection, this.purgeMapStatement(), mapKey));
            this.mapKeys.invalidate(mapId);
        }
    }

    @Language(value="sql")
    public abstract String hasMapStatement();

    @Override
    public boolean hasMap(String mapId) throws IOException {
        return this.db.run(connection -> {
            ResultSet result = AbstractCommandSet.executeQuery(connection, this.hasMapStatement(), mapId);
            if (!result.next()) {
                throw new IllegalStateException("Counting query returned empty result!");
            }
            return result.getBoolean(1);
        });
    }

    @Language(value="sql")
    public abstract String listMapIdsStatement();

    @Override
    public String[] listMapIds(int start, int count) throws IOException {
        return this.db.run(connection -> {
            ResultSet result = AbstractCommandSet.executeQuery(connection, this.listMapIdsStatement(), count, start);
            ArrayList<String> mapIds = new ArrayList<String>();
            while (result.next()) {
                mapIds.add(result.getString(1));
            }
            return (String[])mapIds.toArray(String[]::new);
        });
    }

    @Language(value="sql")
    public abstract String findMapKeyStatement();

    @Language(value="sql")
    public abstract String createMapKeyStatement();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int mapKey(String mapId) {
        LoadingCache<String, Integer> loadingCache = this.mapKeys;
        synchronized (loadingCache) {
            return this.mapKeys.get(mapId);
        }
    }

    public int findOrCreateMapKey(String mapId) throws IOException {
        return this.db.run(connection -> {
            ResultSet result = AbstractCommandSet.executeQuery(connection, this.findMapKeyStatement(), mapId);
            if (result.next()) {
                return result.getInt(1);
            }
            PreparedStatement statement = connection.prepareStatement(this.createMapKeyStatement(), 1);
            statement.setString(1, mapId);
            statement.executeUpdate();
            ResultSet keys = statement.getGeneratedKeys();
            if (!keys.next()) {
                throw new IllegalStateException("No generated key returned!");
            }
            return keys.getInt(1);
        });
    }

    @Language(value="sql")
    public abstract String findCompressionKeyStatement();

    @Language(value="sql")
    public abstract String createCompressionKeyStatement();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int compressionKey(Compression compression) {
        LoadingCache<Compression, Integer> loadingCache = this.compressionKeys;
        synchronized (loadingCache) {
            return this.compressionKeys.get(compression);
        }
    }

    public int findOrCreateCompressionKey(Compression compression) throws IOException {
        return this.db.run(connection -> {
            ResultSet result = AbstractCommandSet.executeQuery(connection, this.findCompressionKeyStatement(), compression.getKey().getFormatted());
            if (result.next()) {
                return result.getInt(1);
            }
            PreparedStatement statement = connection.prepareStatement(this.createCompressionKeyStatement(), 1);
            statement.setString(1, compression.getKey().getFormatted());
            statement.executeUpdate();
            ResultSet keys = statement.getGeneratedKeys();
            if (!keys.next()) {
                throw new IllegalStateException("No generated key returned!");
            }
            return keys.getInt(1);
        });
    }

    @Language(value="sql")
    public abstract String findItemStorageKeyStatement();

    @Language(value="sql")
    public abstract String createItemStorageKeyStatement();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int itemStorageKey(Key key) {
        LoadingCache<Key, Integer> loadingCache = this.itemStorageKeys;
        synchronized (loadingCache) {
            return this.itemStorageKeys.get(key);
        }
    }

    public int findOrCreateItemStorageKey(Key key) throws IOException {
        return this.db.run(connection -> {
            ResultSet result = AbstractCommandSet.executeQuery(connection, this.findItemStorageKeyStatement(), key.getFormatted());
            if (result.next()) {
                return result.getInt(1);
            }
            PreparedStatement statement = connection.prepareStatement(this.createItemStorageKeyStatement(), 1);
            statement.setString(1, key.getFormatted());
            statement.executeUpdate();
            ResultSet keys = statement.getGeneratedKeys();
            if (!keys.next()) {
                throw new IllegalStateException("No generated key returned!");
            }
            return keys.getInt(1);
        });
    }

    @Language(value="sql")
    public abstract String findGridStorageKeyStatement();

    @Language(value="sql")
    public abstract String createGridStorageKeyStatement();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int gridStorageKey(Key key) {
        LoadingCache<Key, Integer> loadingCache = this.gridStorageKeys;
        synchronized (loadingCache) {
            return this.gridStorageKeys.get(key);
        }
    }

    public int findOrCreateGridStorageKey(Key key) throws IOException {
        return this.db.run(connection -> {
            ResultSet result = AbstractCommandSet.executeQuery(connection, this.findGridStorageKeyStatement(), key.getFormatted());
            if (result.next()) {
                return result.getInt(1);
            }
            PreparedStatement statement = connection.prepareStatement(this.createGridStorageKeyStatement(), 1);
            statement.setString(1, key.getFormatted());
            statement.executeUpdate();
            ResultSet keys = statement.getGeneratedKeys();
            if (!keys.next()) {
                throw new IllegalStateException("No generated key returned!");
            }
            return keys.getInt(1);
        });
    }

    @Override
    public boolean isClosed() {
        return this.db.isClosed();
    }

    @Override
    public void close() throws IOException {
        this.db.close();
    }

    protected static ResultSet executeQuery(Connection connection, @Language(value="sql") String sql, Object ... parameters) throws SQLException {
        return AbstractCommandSet.prepareStatement(connection, sql, parameters).executeQuery();
    }

    protected static int executeUpdate(Connection connection, @Language(value="sql") String sql, Object ... parameters) throws SQLException {
        return AbstractCommandSet.prepareStatement(connection, sql, parameters).executeUpdate();
    }

    private static PreparedStatement prepareStatement(Connection connection, @Language(value="sql") String sql, Object ... parameters) throws SQLException {
        PreparedStatement statement = connection.prepareStatement(sql);
        for (int i = 0; i < parameters.length; ++i) {
            statement.setObject(i + 1, parameters[i]);
        }
        return statement;
    }

    public AbstractCommandSet(Database db) {
        this.db = db;
    }
}

