/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.storage.compression;

import de.bluecolored.bluemap.core.storage.compression.Compression;
import de.bluecolored.bluemap.core.util.Key;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class BufferedCompression
implements Compression {
    private final Key key;
    private final String id;
    private final String fileSuffix;
    private final StreamTransformer<OutputStream> compressor;
    private final StreamTransformer<InputStream> decompressor;

    @Override
    public OutputStream compress(OutputStream out) throws IOException {
        return new BufferedOutputStream(this.compressor.apply(out));
    }

    @Override
    public InputStream decompress(InputStream in) throws IOException {
        return new BufferedInputStream(this.decompressor.apply(in));
    }

    public BufferedCompression(Key key, String id, String fileSuffix, StreamTransformer<OutputStream> compressor, StreamTransformer<InputStream> decompressor) {
        this.key = key;
        this.id = id;
        this.fileSuffix = fileSuffix;
        this.compressor = compressor;
        this.decompressor = decompressor;
    }

    @Override
    public Key getKey() {
        return this.key;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getFileSuffix() {
        return this.fileSuffix;
    }

    @FunctionalInterface
    public static interface StreamTransformer<T> {
        public T apply(T var1) throws IOException;
    }
}

