/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.resources.pack.resourcepack.texture;

import de.bluecolored.bluemap.core.resources.ResourcePath;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.texture.AnimationMeta;
import de.bluecolored.bluemap.core.util.BufferedImageUtil;
import de.bluecolored.bluemap.core.util.Keyed;
import de.bluecolored.bluemap.core.util.math.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.Base64;
import javax.imageio.ImageIO;
import org.jetbrains.annotations.Nullable;

public class Texture
implements Keyed {
    private static final String TEXTURE_STRING_PREFIX = "data:image/png;base64,";
    public static final Texture MISSING = new Texture(new ResourcePath<Texture>("bluemap", "missing"), new Color().set(0.5f, 0.0f, 0.5f, 1.0f, false), false, "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAPklEQVR4Xu3MsQkAMAwDQe2/tFPnBB4gpLhG8MpkZpNkZ6AKZKAKZKAKZKAKZKAKZKAKZKAKWg0XD/UPnjg4MbX+EDdeTUwAAAAASUVORK5CYII=", null, null);
    private ResourcePath<Texture> resourcePath;
    private Color color;
    private boolean halfTransparent;
    private String texture;
    @Nullable
    private AnimationMeta animation;
    @Nullable
    private transient Color colorPremultiplied;
    private transient SoftReference<BufferedImage> textureImage = new SoftReference<Object>(null);

    private Texture() {
    }

    private Texture(ResourcePath<Texture> resourcePath, Color color, boolean halfTransparent, String texture, @Nullable AnimationMeta animation, @Nullable BufferedImage textureImage) {
        this.resourcePath = resourcePath;
        this.color = color.straight();
        this.halfTransparent = halfTransparent;
        this.texture = texture;
        this.animation = animation;
        this.textureImage = new SoftReference<BufferedImage>(textureImage);
    }

    private Texture(ResourcePath<Texture> resourcePath) {
        this.resourcePath = resourcePath;
        this.color = Texture.MISSING.color;
        this.halfTransparent = Texture.MISSING.halfTransparent;
        this.texture = Texture.MISSING.texture;
        this.animation = null;
    }

    @Override
    public ResourcePath<Texture> getKey() {
        return this.resourcePath;
    }

    public Color getColorStraight() {
        return this.color;
    }

    public boolean isHalfTransparent() {
        return this.halfTransparent;
    }

    public Color getColorPremultiplied() {
        if (this.colorPremultiplied == null && this.color != null) {
            this.colorPremultiplied = new Color().set(this.color).premultiplied();
        }
        return this.colorPremultiplied;
    }

    public String getTexture() {
        return this.texture;
    }

    public BufferedImage getTextureImage() throws IOException {
        BufferedImage image = this.textureImage.get();
        if (image != null) {
            return image;
        }
        if (!this.texture.startsWith(TEXTURE_STRING_PREFIX)) {
            throw new IOException("Texture-string is not in the expected format.");
        }
        byte[] imageData = Base64.getDecoder().decode(this.texture.substring(TEXTURE_STRING_PREFIX.length()));
        image = ImageIO.read(new ByteArrayInputStream(imageData));
        this.textureImage = new SoftReference<BufferedImage>(image);
        return image;
    }

    @Nullable
    public AnimationMeta getAnimation() {
        return this.animation;
    }

    public static Texture from(ResourcePath<Texture> resourcePath, BufferedImage image) throws IOException {
        return Texture.from(resourcePath, image, null);
    }

    public static Texture from(ResourcePath<Texture> resourcePath, BufferedImage image, @Nullable AnimationMeta animation) throws IOException {
        boolean halfTransparent = BufferedImageUtil.halfTransparent(image);
        Color color = BufferedImageUtil.averageColor(image);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, "png", os);
        String base64 = TEXTURE_STRING_PREFIX + Base64.getEncoder().encodeToString(os.toByteArray());
        return new Texture(resourcePath, color, halfTransparent, base64, animation, image);
    }

    public static Texture missing(ResourcePath<Texture> resourcePath) {
        return new Texture(resourcePath);
    }
}

