/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.resources.pack.resourcepack.model;

import com.flowpowered.math.vector.Vector3f;
import de.bluecolored.bluemap.core.resources.adapter.PostDeserialize;
import de.bluecolored.bluemap.core.util.math.Axis;
import de.bluecolored.bluemap.core.util.math.MatrixM4f;
import de.bluecolored.bluemap.core.util.math.VectorM3f;

public class Rotation {
    private static final Vector3f DEFAULT_ORIGIN = new Vector3f(8.0f, 8.0f, 8.0f);
    public static final Rotation ZERO = new Rotation();
    private Vector3f origin = DEFAULT_ORIGIN;
    private float x;
    private float y;
    private float z;
    private Axis axis = Axis.Y;
    private float angle = 0.0f;
    private boolean rescale = false;
    private transient MatrixM4f matrix;

    public Rotation(Vector3f origin, Axis axis, float angle, boolean rescale) {
        this.origin = origin;
        this.axis = axis;
        this.angle = angle;
        this.rescale = rescale;
        this.init();
    }

    public Rotation(Vector3f origin, float x, float y, float z, boolean rescale) {
        this.origin = origin;
        this.x = x;
        this.y = y;
        this.z = z;
        this.rescale = rescale;
        this.init();
    }

    @PostDeserialize
    private void init() {
        if (this.angle != 0.0f) {
            this.z = 0.0f;
            this.y = 0.0f;
            this.x = 0.0f;
            switch (this.axis) {
                case X: {
                    this.x = this.angle;
                    break;
                }
                case Y: {
                    this.y = this.angle;
                    break;
                }
                case Z: {
                    this.z = this.angle;
                }
            }
        }
        this.matrix = new MatrixM4f();
        if (this.x != 0.0f || this.y != 0.0f || this.z != 0.0f) {
            this.matrix.translate(-this.origin.getX(), -this.origin.getY(), -this.origin.getZ());
            this.matrix.rotateYXZ(this.x, this.y, this.z);
            if (this.rescale) {
                VectorM3f axisVector = new VectorM3f(0.0f, 0.0f, 0.0f);
                float sX = 1.0f / axisVector.set(1.0f, 0.0f, 0.0f).rotateAndScale(this.matrix).absolute().max();
                float sY = 1.0f / axisVector.set(0.0f, 1.0f, 0.0f).rotateAndScale(this.matrix).absolute().max();
                float sZ = 1.0f / axisVector.set(0.0f, 0.0f, 1.0f).rotateAndScale(this.matrix).absolute().max();
                this.matrix.identity();
                this.matrix.translate(-this.origin.getX(), -this.origin.getY(), -this.origin.getZ());
                this.matrix.scale(sX, sY, sZ);
                this.matrix.rotateYXZ(this.x, this.y, this.z);
            }
            this.matrix.translate(this.origin.getX(), this.origin.getY(), this.origin.getZ());
        }
    }

    private Rotation() {
    }

    public Vector3f getOrigin() {
        return this.origin;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getZ() {
        return this.z;
    }

    public Axis getAxis() {
        return this.axis;
    }

    public float getAngle() {
        return this.angle;
    }

    public boolean isRescale() {
        return this.rescale;
    }

    public MatrixM4f getMatrix() {
        return this.matrix;
    }

    static {
        ZERO.init();
    }
}

