/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.resources.pack.resourcepack.model;

import com.flowpowered.math.vector.Vector3f;
import com.flowpowered.math.vector.Vector4f;
import de.bluecolored.bluemap.core.resources.adapter.PostDeserialize;
import de.bluecolored.bluemap.core.resources.pack.ResourcePool;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.model.Face;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.model.Rotation;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.texture.Texture;
import de.bluecolored.bluemap.core.util.Direction;
import java.util.EnumMap;
import java.util.Map;

public class Element {
    private static final Vector3f FULL_BLOCK_MIN = Vector3f.ZERO;
    private static final Vector3f FULL_BLOCK_MAX = new Vector3f(16.0f, 16.0f, 16.0f);
    private Vector3f from = FULL_BLOCK_MIN;
    private Vector3f to = FULL_BLOCK_MAX;
    private Rotation rotation = Rotation.ZERO;
    private boolean shade = true;
    private int lightEmission = 0;
    private EnumMap<Direction, Face> faces = new EnumMap(Direction.class);

    public Element(Vector3f from, Vector3f to, Map<Direction, Face> faces) {
        this.from = from;
        this.to = to;
        this.faces.putAll(faces);
        this.init();
    }

    public Element(Vector3f from, Vector3f to, Rotation rotation, Map<Direction, Face> faces) {
        this.from = from;
        this.to = to;
        this.rotation = rotation;
        this.faces.putAll(faces);
        this.init();
    }

    public Element(Vector3f from, Vector3f to, Rotation rotation, boolean shade, int lightEmission, Map<Direction, Face> faces) {
        this.from = from;
        this.to = to;
        this.rotation = rotation;
        this.shade = shade;
        this.lightEmission = lightEmission;
        this.faces.putAll(faces);
        this.init();
    }

    private Element(Element copyFrom) {
        this.from = copyFrom.from;
        this.to = copyFrom.to;
        this.rotation = copyFrom.rotation;
        this.shade = copyFrom.shade;
        this.lightEmission = copyFrom.lightEmission;
        copyFrom.faces.forEach((direction, face) -> this.faces.put((Direction)((Object)direction), face.copy()));
    }

    @PostDeserialize
    private void init() {
        this.faces.forEach((direction, face) -> face.init((Direction)((Object)direction), this::calculateDefaultUV));
    }

    private Vector4f calculateDefaultUV(Direction face) {
        return switch (face) {
            default -> throw new MatchException(null, null);
            case Direction.UP -> new Vector4f(this.from.getX(), this.from.getZ(), this.to.getX(), this.to.getZ());
            case Direction.DOWN -> new Vector4f(this.from.getX(), 16.0f - this.to.getZ(), this.to.getX(), 16.0f - this.from.getZ());
            case Direction.NORTH -> new Vector4f(16.0f - this.to.getX(), 16.0f - this.to.getY(), 16.0f - this.from.getX(), 16.0f - this.from.getY());
            case Direction.SOUTH -> new Vector4f(this.from.getX(), 16.0f - this.to.getY(), this.to.getX(), 16.0f - this.from.getY());
            case Direction.EAST -> new Vector4f(16.0f - this.to.getZ(), 16.0f - this.to.getY(), 16.0f - this.from.getZ(), 16.0f - this.from.getY());
            case Direction.WEST -> new Vector4f(this.from.getZ(), 16.0f - this.to.getY(), this.to.getZ(), 16.0f - this.from.getY());
        };
    }

    public Element copy() {
        return new Element(this);
    }

    boolean isFullCube() {
        if (!FULL_BLOCK_MIN.equals((Object)this.from) || !FULL_BLOCK_MAX.equals((Object)this.to)) {
            return false;
        }
        for (Direction dir : Direction.values()) {
            if (this.faces.containsKey((Object)dir)) continue;
            return false;
        }
        return true;
    }

    public void optimize(ResourcePool<Texture> texturePool) {
        for (Face face : this.faces.values()) {
            face.optimize(texturePool);
        }
    }

    private Element() {
    }

    public Vector3f getFrom() {
        return this.from;
    }

    public Vector3f getTo() {
        return this.to;
    }

    public Rotation getRotation() {
        return this.rotation;
    }

    public boolean isShade() {
        return this.shade;
    }

    public int getLightEmission() {
        return this.lightEmission;
    }

    public EnumMap<Direction, Face> getFaces() {
        return this.faces;
    }
}

