/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.resources.pack.resourcepack.atlas;

import de.bluecolored.bluemap.core.resources.ResourcePath;
import de.bluecolored.bluemap.core.resources.pack.Pack;
import de.bluecolored.bluemap.core.resources.pack.ResourcePool;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.atlas.Source;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.texture.Texture;
import de.bluecolored.bluemap.core.util.Key;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nullable;

public class DirectorySource
extends Source {
    private String source;
    private String prefix = "";

    public DirectorySource(String source) {
        this.source = source;
    }

    @Override
    public void load(Path root, ResourcePool<Texture> textures, Predicate<Key> textureFilter) throws IOException {
        if (this.source == null) {
            return;
        }
        String source = this.source.replace("/", root.getFileSystem().getSeparator());
        Pack.list(root.resolve("assets")).forEach(namespacePath -> {
            String namespace = namespacePath.getFileName().toString();
            Path sourcePath = namespacePath.resolve("textures").resolve(source);
            Pack.walk(sourcePath).filter(path -> path.getFileName().toString().endsWith(".png")).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(file -> {
                Path namePath = sourcePath.relativize((Path)file);
                Object name = this.prefix + namePath.toString().replace(root.getFileSystem().getSeparator(), "/");
                ResourcePath resourcePath = new ResourcePath(namespace, (String)(name = ((String)name).substring(0, ((String)name).length() - 4)));
                if (textureFilter.test(resourcePath)) {
                    textures.load(resourcePath, rp -> this.loadTexture(resourcePath, (Path)file));
                }
            });
        });
    }

    @Override
    @Nullable
    protected Texture loadTexture(ResourcePath<Texture> key, Path file) {
        return super.loadTexture(key, file);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        DirectorySource that = (DirectorySource)object;
        return Objects.equals(this.source, that.source) && Objects.equals(this.prefix, that.prefix);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.source);
        result = 31 * result + Objects.hashCode(this.prefix);
        return result;
    }

    public String getSource() {
        return this.source;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public DirectorySource(String source, String prefix) {
        this.source = source;
        this.prefix = prefix;
    }

    private DirectorySource() {
    }
}

