/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.resources.pack.datapack.biome;

import de.bluecolored.bluemap.core.resources.adapter.PostDeserialize;
import de.bluecolored.bluemap.core.util.Key;
import de.bluecolored.bluemap.core.util.math.Color;
import de.bluecolored.bluemap.core.world.biome.Biome;
import de.bluecolored.bluemap.core.world.biome.GrassColorModifier;

public class DatapackBiome
implements Biome {
    private final Key key;
    private final Data data;

    @Override
    public float getDownfall() {
        return this.data.downfall;
    }

    @Override
    public float getTemperature() {
        return this.data.temperature;
    }

    @Override
    public Color getWaterColor() {
        return this.data.effects.waterColor;
    }

    @Override
    public Color getOverlayFoliageColor() {
        return this.data.effects.foliageColor;
    }

    @Override
    public Color getOverlayDryFoliageColor() {
        return this.data.effects.dryFoliageColor;
    }

    @Override
    public Color getOverlayGrassColor() {
        return this.data.effects.grassColor;
    }

    @Override
    public GrassColorModifier getGrassColorModifier() {
        return this.data.effects.grassColorModifier;
    }

    public DatapackBiome(Key key, Data data) {
        this.key = key;
        this.data = data;
    }

    @Override
    public Key getKey() {
        return this.key;
    }

    public Data getData() {
        return this.data;
    }

    public static class Data {
        private Effects effects = new Effects();
        private float temperature = Biome.DEFAULT.getTemperature();
        private float downfall = Biome.DEFAULT.getDownfall();

        public Effects getEffects() {
            return this.effects;
        }

        public float getTemperature() {
            return this.temperature;
        }

        public float getDownfall() {
            return this.downfall;
        }
    }

    public static class Effects {
        private Color waterColor = Biome.DEFAULT.getWaterColor();
        private Color foliageColor = Biome.DEFAULT.getOverlayFoliageColor();
        private Color dryFoliageColor = Biome.DEFAULT.getOverlayDryFoliageColor();
        private Color grassColor = Biome.DEFAULT.getOverlayGrassColor();
        private GrassColorModifier grassColorModifier = Biome.DEFAULT.getGrassColorModifier();

        @PostDeserialize
        private void init() {
            this.waterColor.a = 1.0f;
        }

        public Color getWaterColor() {
            return this.waterColor;
        }

        public Color getFoliageColor() {
            return this.foliageColor;
        }

        public Color getDryFoliageColor() {
            return this.dryFoliageColor;
        }

        public Color getGrassColor() {
            return this.grassColor;
        }

        public GrassColorModifier getGrassColorModifier() {
            return this.grassColorModifier;
        }
    }
}

