/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.resources.pack;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@JsonAdapter(value=MinAdapter.class)
public class PackVersion {
    private int major;
    private int minor;

    public boolean isGreaterOrEqual(PackVersion other) {
        if (other.major == this.major) {
            return other.minor >= this.minor;
        }
        return other.major > this.major;
    }

    public boolean isSmallerOrEqual(PackVersion other) {
        if (other.major == this.major) {
            return other.minor <= this.minor;
        }
        return other.major < this.major;
    }

    public PackVersion(int major, int minor) {
        this.major = major;
        this.minor = minor;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public String toString() {
        return "PackVersion(major=" + this.getMajor() + ", minor=" + this.getMinor() + ")";
    }

    public static class MaxAdapter
    extends Adapter {
        public MaxAdapter() {
            super(Integer.MAX_VALUE);
        }
    }

    public static class MinAdapter
    extends Adapter {
        public MinAdapter() {
            super(0);
        }
    }

    public static class Adapter
    extends TypeAdapter<PackVersion> {
        private static final Pattern VERSION_STRING_PATTERN = Pattern.compile("^(\\d+)(?:\\.(\\d+))?$");
        private final int defaultMinor;

        public Adapter(int defaultMinor) {
            this.defaultMinor = defaultMinor;
        }

        public void write(JsonWriter out, PackVersion value) {
            throw new UnsupportedOperationException();
        }

        public PackVersion read(JsonReader in) throws IOException {
            return switch (in.peek()) {
                case JsonToken.STRING -> this.parseString(in.nextString());
                case JsonToken.NUMBER -> {
                    double version = in.nextDouble();
                    if (version == Math.floor(version)) {
                        yield new PackVersion((int)version, this.defaultMinor);
                    }
                    yield this.parseString("%.9f".formatted(version));
                }
                case JsonToken.BEGIN_ARRAY -> {
                    in.beginArray();
                    int major = in.nextInt();
                    int minor = in.hasNext() ? in.nextInt() : this.defaultMinor;
                    in.endArray();
                    yield new PackVersion(major, minor);
                }
                default -> throw new IOException("Invalid version format: '%s'!".formatted(in.peek()));
            };
        }

        private PackVersion parseString(String versionString) throws IOException {
            Matcher versionStringMatcher = VERSION_STRING_PATTERN.matcher(versionString);
            if (!versionStringMatcher.matches()) {
                throw new IOException("Invalid version string: '%s'!".formatted(versionString));
            }
            String major = versionStringMatcher.group(1);
            String minor = versionStringMatcher.group(2);
            return new PackVersion(Integer.parseInt(major), minor != null && !minor.isEmpty() ? Integer.parseInt(minor) : this.defaultMinor);
        }
    }
}

