/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.map.mask;

import com.flowpowered.math.vector.Vector2d;
import de.bluecolored.bluemap.core.map.mask.Mask;
import de.bluecolored.bluemap.core.util.Tristate;

public class EllipseMask
implements Mask {
    private final Vector2d center;
    private final double radiusSquaredX;
    private final double radiusSquaredZ;
    private final int minY;
    private final int maxY;

    public EllipseMask(Vector2d center, double radius, int minY, int maxY) {
        this.center = center;
        this.radiusSquaredZ = this.radiusSquaredX = radius * radius;
        this.minY = minY;
        this.maxY = maxY;
    }

    public EllipseMask(Vector2d center, double radiusX, double radiusZ, int minY, int maxY) {
        this.center = center;
        this.radiusSquaredX = radiusX * radiusX;
        this.radiusSquaredZ = radiusZ * radiusZ;
        this.minY = minY;
        this.maxY = maxY;
    }

    @Override
    public boolean test(int x, int y, int z) {
        return this.minY <= y && this.maxY >= y && this.testXZ(x, z);
    }

    public boolean testXZ(double x, double z) {
        return (x -= this.center.getX()) * x / this.radiusSquaredX + (z -= this.center.getY()) * z / this.radiusSquaredZ <= 1.0;
    }

    @Override
    public Tristate test(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        return this.testY(minY, maxY).and(() -> this.testXZ(minX, minZ, maxX, maxZ));
    }

    public Tristate testXZ(int minX, int minZ, int maxX, int maxZ) {
        double closestZ;
        if (this.testXZ(minX, minZ) && this.testXZ(maxX, minZ) && this.testXZ(minX, maxZ) && this.testXZ(maxX, maxZ)) {
            return Tristate.TRUE;
        }
        double closestX = Math.clamp(this.center.getX(), (double)minX, (double)maxX);
        if (!this.testXZ(closestX, closestZ = Math.clamp(this.center.getY(), (double)minZ, (double)maxZ))) {
            return Tristate.FALSE;
        }
        return Tristate.UNDEFINED;
    }

    public Tristate testY(int minY, int maxY) {
        if (maxY < this.minY || minY > this.maxY) {
            return Tristate.FALSE;
        }
        if (minY >= this.minY && maxY <= this.maxY) {
            return Tristate.TRUE;
        }
        return Tristate.UNDEFINED;
    }

    @Override
    public boolean isEdge(int minX, int minZ, int maxX, int maxZ) {
        return this.testXZ(minX, minZ, maxX, maxZ) == Tristate.UNDEFINED;
    }
}

