/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.map.lowres;

import com.flowpowered.math.vector.Vector2i;
import de.bluecolored.bluemap.core.logger.Logger;
import de.bluecolored.bluemap.core.map.lowres.LowresTile;
import de.bluecolored.bluemap.core.storage.GridStorage;
import de.bluecolored.bluemap.core.storage.compression.CompressedInputStream;
import de.bluecolored.bluemap.core.util.Caches;
import de.bluecolored.bluemap.core.util.Grid;
import de.bluecolored.bluemap.core.util.Vector2iCache;
import de.bluecolored.bluemap.core.util.math.Color;
import de.bluecolored.shadow.caffeine.cache.LoadingCache;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.Nullable;

public class LowresLayer {
    private static final int MAX_PENDING = 200;
    private static final int DISCARD_THRESHOLD = 100;
    private static final Vector2iCache VECTOR_2_I_CACHE = new Vector2iCache();
    private final GridStorage storage;
    private final Grid tileGrid;
    private final int lodFactor;
    private final int lod;
    private final LoadingCache<Vector2i, LowresTile> tileWeakInstanceCache;
    private final LoadingCache<Vector2i, LowresTile> tileCache;
    @Nullable
    private final LowresLayer nextLayer;
    private final Map<Vector2i, LowresTile> pendingChanges;

    public LowresLayer(GridStorage storage, Grid tileGrid, int lodFactor, int lod, @Nullable LowresLayer nextLayer) {
        this.storage = storage;
        this.tileGrid = tileGrid;
        this.lodFactor = lodFactor;
        this.lod = lod;
        this.nextLayer = nextLayer;
        this.tileWeakInstanceCache = Caches.with().weakValues().build(this::createTile);
        this.tileCache = Caches.with().softValues().maximumSize(1000L).expireAfterAccess(1L, TimeUnit.MINUTES).build(this.tileWeakInstanceCache::get);
        this.pendingChanges = new ConcurrentHashMap<Vector2i, LowresTile>();
    }

    public void save() {
        this.pendingChanges.entrySet().removeIf(entry -> this.saveTile((Vector2i)entry.getKey(), (LowresTile)entry.getValue()));
        if (this.pendingChanges.size() >= 100) {
            Logger.global.logDebug("Discarding changes of " + this.pendingChanges.size() + " lowres-tiles that failed to save!");
            this.pendingChanges.clear();
        }
    }

    public void discard() {
        this.pendingChanges.clear();
        this.tileCache.invalidateAll();
        this.tileWeakInstanceCache.invalidateAll();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private LowresTile createTile(Vector2i tilePos) {
        try (CompressedInputStream in = this.storage.read(tilePos.getX(), tilePos.getY());){
            if (in == null) return new LowresTile(this.tileGrid.getGridSize());
            LowresTile lowresTile = new LowresTile(this.tileGrid.getGridSize(), in);
            return lowresTile;
        }
        catch (IOException e) {
            Logger.global.logError("Failed to load tile " + String.valueOf(tilePos) + " (lod: " + this.lod + ")", e);
        }
        return new LowresTile(this.tileGrid.getGridSize());
    }

    private boolean saveTile(Vector2i tilePos, LowresTile tile) {
        if (this.storage.isClosed()) {
            Logger.global.logDebug("Tried to save tile " + String.valueOf(tilePos) + " (lod: " + this.lod + ") but storage is already closed.");
            return false;
        }
        try (OutputStream out = this.storage.write(tilePos.getX(), tilePos.getY());){
            tile.save(out);
        }
        catch (IOException e) {
            Logger.global.logError("Failed to save tile " + String.valueOf(tilePos) + " (lod: " + this.lod + ")", e);
            return false;
        }
        if (this.nextLayer == null) {
            return true;
        }
        Color averageColor = new Color();
        Color color = new Color();
        int nextLodTileX = Math.floorDiv(tilePos.getX(), this.lodFactor);
        int nextLodTileY = Math.floorDiv(tilePos.getY(), this.lodFactor);
        Vector2i groupCount = new Vector2i(Math.floorDiv(this.tileGrid.getGridSize().getX(), this.lodFactor), Math.floorDiv(this.tileGrid.getGridSize().getY(), this.lodFactor));
        for (int gX = 0; gX < groupCount.getX(); ++gX) {
            for (int gY = 0; gY < groupCount.getY(); ++gY) {
                averageColor.set(0.0f, 0.0f, 0.0f, 0.0f, true);
                int averageHeight = 0;
                int averageBlockLight = 0;
                int count = 0;
                for (int x = 0; x < this.lodFactor; ++x) {
                    for (int y = 0; y < this.lodFactor; ++y) {
                        ++count;
                        averageColor.add(tile.getColor(gX * this.lodFactor + x, gY * this.lodFactor + y, color).premultiplied());
                        averageHeight += tile.getHeight(gX * this.lodFactor + x, gY * this.lodFactor + y);
                        averageBlockLight += tile.getBlockLight(gX * this.lodFactor + x, gY * this.lodFactor + y);
                    }
                }
                averageColor.div(count);
                this.nextLayer.set(nextLodTileX, nextLodTileY, Math.floorMod(tilePos.getX(), this.lodFactor) * groupCount.getX() + gX, Math.floorMod(tilePos.getY(), this.lodFactor) * groupCount.getY() + gY, averageColor, averageHeight /= count, averageBlockLight /= count);
            }
        }
        return true;
    }

    private LowresTile accessTile(int x, int z) {
        Vector2i tilePos = VECTOR_2_I_CACHE.get(x, z);
        LowresTile tile = this.tileCache.get(tilePos);
        if (this.pendingChanges.size() >= 200) {
            this.save();
        }
        this.pendingChanges.put(tilePos, tile);
        return tile;
    }

    void set(int cellX, int cellZ, int pixelX, int pixelZ, Color color, int height, int blockLight) {
        this.accessTile(cellX, cellZ).set(pixelX, pixelZ, color, height, blockLight);
        if (pixelX == 0) {
            this.accessTile(cellX - 1, cellZ).set(this.tileGrid.getGridSize().getX(), pixelZ, color, height, blockLight);
        }
        if (pixelZ == 0) {
            this.accessTile(cellX, cellZ - 1).set(pixelX, this.tileGrid.getGridSize().getY(), color, height, blockLight);
        }
        if (pixelX == 0 && pixelZ == 0) {
            this.accessTile(cellX - 1, cellZ - 1).set(this.tileGrid.getGridSize().getX(), this.tileGrid.getGridSize().getY(), color, height, blockLight);
        }
    }
}

