/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.map.hires.entity;

import com.flowpowered.math.vector.Vector3f;
import com.flowpowered.math.vector.Vector4f;
import de.bluecolored.bluemap.core.map.TextureGallery;
import de.bluecolored.bluemap.core.map.hires.RenderSettings;
import de.bluecolored.bluemap.core.map.hires.TileModel;
import de.bluecolored.bluemap.core.map.hires.TileModelView;
import de.bluecolored.bluemap.core.map.hires.entity.EntityRenderer;
import de.bluecolored.bluemap.core.resources.ResourcePath;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.ResourcePack;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.entitystate.Part;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.model.Element;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.model.Face;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.model.Model;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.texture.Texture;
import de.bluecolored.bluemap.core.util.Direction;
import de.bluecolored.bluemap.core.util.math.Color;
import de.bluecolored.bluemap.core.util.math.MatrixM4f;
import de.bluecolored.bluemap.core.util.math.VectorM2f;
import de.bluecolored.bluemap.core.util.math.VectorM3f;
import de.bluecolored.bluemap.core.world.Entity;
import de.bluecolored.bluemap.core.world.LightData;
import de.bluecolored.bluemap.core.world.block.BlockNeighborhood;
import java.util.function.Function;

public class ResourceModelRenderer
implements EntityRenderer {
    private static final float SCALE = 0.0625f;
    private final Function<ResourcePath<Model>, Model> modelProvider;
    private final TextureGallery textureGallery;
    private final RenderSettings renderSettings;
    private final VectorM3f[] corners = new VectorM3f[8];
    private final VectorM2f[] rawUvs = new VectorM2f[4];
    private final VectorM2f[] uvs = new VectorM2f[4];
    private final Color tintColor = new Color();
    private Model modelResource;
    private TileModelView tileModel;
    private int sunLight;
    private int blockLight;
    private TintColorProvider tintProvider;
    private final MatrixM4f modelElementTransform = new MatrixM4f();

    public ResourceModelRenderer(ResourcePack resourcePack, TextureGallery textureGallery, RenderSettings renderSettings) {
        int i;
        this.modelProvider = resourcePack.getModels()::get;
        this.textureGallery = textureGallery;
        this.renderSettings = renderSettings;
        for (i = 0; i < this.corners.length; ++i) {
            this.corners[i] = new VectorM3f(0.0f, 0.0f, 0.0f);
        }
        for (i = 0; i < this.rawUvs.length; ++i) {
            this.rawUvs[i] = new VectorM2f(0.0f, 0.0f);
        }
    }

    @Override
    public void render(Entity entity, BlockNeighborhood block, Part part, TileModelView tileModel) {
        this.render(entity, block, part.getModel().getResource(this.modelProvider), TintColorProvider.NO_TINT, tileModel);
        if (part.isTransformed()) {
            tileModel.transform(part.getTransformMatrix());
        }
    }

    void render(Entity entity, BlockNeighborhood block, Model model, TintColorProvider tintProvider, TileModelView tileModel) {
        this.modelResource = model;
        this.tileModel = tileModel;
        this.tintProvider = tintProvider;
        LightData blockLightData = block.getLightData();
        this.sunLight = blockLightData.getSkyLight();
        this.blockLight = blockLightData.getBlockLight();
        if (block.isRemoveIfCave() && (this.renderSettings.isCaveDetectionUsesBlockLight() ? Math.max(this.blockLight, this.sunLight) : this.sunLight) == 0) {
            return;
        }
        int modelStart = this.tileModel.getStart();
        Element[] elements = this.modelResource.getElements();
        if (elements != null) {
            for (Element element : elements) {
                this.buildModelElementResource(element, this.tileModel.initialize());
            }
        }
        this.tileModel.initialize(modelStart);
    }

    private void buildModelElementResource(Element element, TileModelView blockModel) {
        Vector3f from = element.getFrom();
        Vector3f to = element.getTo();
        float minX = from.getX();
        float minY = from.getY();
        float minZ = from.getZ();
        float maxX = to.getX();
        float maxY = to.getY();
        float maxZ = to.getZ();
        VectorM3f[] c = this.corners;
        c[0].x = minX;
        c[0].y = minY;
        c[0].z = minZ;
        c[1].x = minX;
        c[1].y = minY;
        c[1].z = maxZ;
        c[2].x = maxX;
        c[2].y = minY;
        c[2].z = minZ;
        c[3].x = maxX;
        c[3].y = minY;
        c[3].z = maxZ;
        c[4].x = minX;
        c[4].y = maxY;
        c[4].z = minZ;
        c[5].x = minX;
        c[5].y = maxY;
        c[5].z = maxZ;
        c[6].x = maxX;
        c[6].y = maxY;
        c[6].z = minZ;
        c[7].x = maxX;
        c[7].y = maxY;
        c[7].z = maxZ;
        int modelStart = blockModel.getStart();
        this.createElementFace(element, Direction.DOWN, c[0], c[2], c[3], c[1]);
        this.createElementFace(element, Direction.UP, c[5], c[7], c[6], c[4]);
        this.createElementFace(element, Direction.NORTH, c[2], c[0], c[4], c[6]);
        this.createElementFace(element, Direction.SOUTH, c[1], c[3], c[7], c[5]);
        this.createElementFace(element, Direction.WEST, c[0], c[1], c[5], c[4]);
        this.createElementFace(element, Direction.EAST, c[3], c[2], c[6], c[7]);
        blockModel.initialize(modelStart);
        blockModel.transform(this.modelElementTransform.copy(element.getRotation().getMatrix()).scale(0.0625f, 0.0625f, 0.0625f));
    }

    private void createElementFace(Element element, Direction faceDir, VectorM3f c0, VectorM3f c1, VectorM3f c2, VectorM3f c3) {
        Face face = element.getFaces().get((Object)faceDir);
        if (face == null) {
            return;
        }
        this.tileModel.initialize();
        this.tileModel.add(2);
        TileModel tileModel = this.tileModel.getTileModel();
        int face1 = this.tileModel.getStart();
        int face2 = face1 + 1;
        tileModel.setPositions(face1, c0.x, c0.y, c0.z, c1.x, c1.y, c1.z, c2.x, c2.y, c2.z);
        tileModel.setPositions(face2, c0.x, c0.y, c0.z, c2.x, c2.y, c2.z, c3.x, c3.y, c3.z);
        ResourcePath<Texture> texturePath = face.getTexture().getTexturePath(this.modelResource.getTextures()::get);
        int textureId = this.textureGallery.get(texturePath);
        tileModel.setMaterialIndex(face1, textureId);
        tileModel.setMaterialIndex(face2, textureId);
        Vector4f uvRaw = face.getUv();
        float uvx = uvRaw.getX() / 16.0f;
        float uvy = uvRaw.getY() / 16.0f;
        float uvz = uvRaw.getZ() / 16.0f;
        float uvw = uvRaw.getW() / 16.0f;
        this.rawUvs[0].set(uvx, uvw);
        this.rawUvs[1].set(uvz, uvw);
        this.rawUvs[2].set(uvz, uvy);
        this.rawUvs[3].set(uvx, uvy);
        int rotationSteps = Math.floorDiv(face.getRotation(), 90) % 4;
        if (rotationSteps < 0) {
            rotationSteps += 4;
        }
        for (int i = 0; i < 4; ++i) {
            this.uvs[i] = this.rawUvs[(rotationSteps + i) % 4];
        }
        tileModel.setUvs(face1, this.uvs[0].x, this.uvs[0].y, this.uvs[1].x, this.uvs[1].y, this.uvs[2].x, this.uvs[2].y);
        tileModel.setUvs(face2, this.uvs[0].x, this.uvs[0].y, this.uvs[2].x, this.uvs[2].y, this.uvs[3].x, this.uvs[3].y);
        if (face.getTintindex() >= 0) {
            this.tintProvider.setTintColor(face.getTintindex(), this.tintColor);
            tileModel.setColor(face1, this.tintColor.r, this.tintColor.g, this.tintColor.b);
            tileModel.setColor(face2, this.tintColor.r, this.tintColor.g, this.tintColor.b);
        } else {
            tileModel.setColor(face1, 1.0f, 1.0f, 1.0f);
            tileModel.setColor(face2, 1.0f, 1.0f, 1.0f);
        }
        int emissiveBlockLight = Math.max(this.blockLight, element.getLightEmission());
        tileModel.setBlocklight(face1, emissiveBlockLight);
        tileModel.setBlocklight(face2, emissiveBlockLight);
        tileModel.setSunlight(face1, this.sunLight);
        tileModel.setSunlight(face2, this.sunLight);
        tileModel.setAOs(face1, 1.0f, 1.0f, 1.0f);
        tileModel.setAOs(face2, 1.0f, 1.0f, 1.0f);
    }

    public Function<ResourcePath<Model>, Model> getModelProvider() {
        return this.modelProvider;
    }

    public TextureGallery getTextureGallery() {
        return this.textureGallery;
    }

    public RenderSettings getRenderSettings() {
        return this.renderSettings;
    }

    static interface TintColorProvider {
        public static final TintColorProvider NO_TINT = (index, color) -> color.set(1.0f, 1.0f, 1.0f, 1.0f, true);

        public void setTintColor(int var1, Color var2);
    }
}

