/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.map.hires.entity;

import com.flowpowered.math.vector.Vector3d;
import com.flowpowered.math.vector.Vector3i;
import de.bluecolored.bluemap.core.map.TextureGallery;
import de.bluecolored.bluemap.core.map.TileMetaConsumer;
import de.bluecolored.bluemap.core.map.hires.RenderPass;
import de.bluecolored.bluemap.core.map.hires.RenderSettings;
import de.bluecolored.bluemap.core.map.hires.TileModelView;
import de.bluecolored.bluemap.core.map.hires.entity.EntityModelRenderer;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.ResourcePack;
import de.bluecolored.bluemap.core.world.Entity;
import de.bluecolored.bluemap.core.world.World;
import de.bluecolored.bluemap.core.world.block.Block;
import de.bluecolored.bluemap.core.world.block.BlockNeighborhood;

public class EntityRenderPass
implements RenderPass {
    private final ResourcePack resourcePack;
    private final RenderSettings renderSettings;
    private final EntityModelRenderer entityRenderer;

    public EntityRenderPass(ResourcePack resourcePack, TextureGallery textureGallery, RenderSettings renderSettings) {
        this.resourcePack = resourcePack;
        this.renderSettings = renderSettings;
        this.entityRenderer = new EntityModelRenderer(resourcePack, textureGallery, renderSettings);
    }

    @Override
    public void render(World world, Vector3i modelMin, Vector3i modelMax, Vector3i modelAnchor, TileModelView model, TileMetaConsumer tileMetaConsumer) {
        BlockNeighborhood block = new BlockNeighborhood(new Block(world, 0, 0, 0), this.resourcePack, this.renderSettings, world.getDimensionType());
        world.iterateEntities(modelMin.getX(), modelMin.getZ(), modelMax.getX(), modelMax.getZ(), entity -> {
            Vector3d pos = entity.getPos();
            block.set(pos.getFloorX(), pos.getFloorY(), pos.getFloorZ());
            this.entityRenderer.render((Entity)entity, block, model.initialize());
            model.translate((float)pos.getX() - (float)modelAnchor.getX(), (float)pos.getY() - (float)modelAnchor.getY(), (float)pos.getZ() - (float)modelAnchor.getZ());
        });
    }
}

