/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.map.hires.block;

import com.flowpowered.math.vector.Vector3i;
import de.bluecolored.bluemap.core.map.TextureGallery;
import de.bluecolored.bluemap.core.map.TileMetaConsumer;
import de.bluecolored.bluemap.core.map.hires.RenderPass;
import de.bluecolored.bluemap.core.map.hires.RenderSettings;
import de.bluecolored.bluemap.core.map.hires.TileModelView;
import de.bluecolored.bluemap.core.map.hires.block.BlockStateModelRenderer;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.ResourcePack;
import de.bluecolored.bluemap.core.util.math.Color;
import de.bluecolored.bluemap.core.world.Chunk;
import de.bluecolored.bluemap.core.world.World;
import de.bluecolored.bluemap.core.world.block.Block;
import de.bluecolored.bluemap.core.world.block.BlockNeighborhood;

public class BlockRenderPass
implements RenderPass {
    private final ResourcePack resourcePack;
    private final RenderSettings renderSettings;
    private final BlockStateModelRenderer blockRenderer;

    public BlockRenderPass(ResourcePack resourcePack, TextureGallery textureGallery, RenderSettings renderSettings) {
        this.resourcePack = resourcePack;
        this.renderSettings = renderSettings;
        this.blockRenderer = new BlockStateModelRenderer(resourcePack, textureGallery, renderSettings);
    }

    @Override
    public void render(World world, Vector3i modelMin, Vector3i modelMax, Vector3i modelAnchor, TileModelView model, TileMetaConsumer tileMetaConsumer) {
        Color columnColor = new Color();
        Color blockColor = new Color();
        BlockNeighborhood block = new BlockNeighborhood(new Block(world, 0, 0, 0), this.resourcePack, this.renderSettings, world.getDimensionType());
        for (int x = modelMin.getX(); x <= modelMax.getX(); ++x) {
            for (int z = modelMin.getZ(); z <= modelMax.getZ(); ++z) {
                int maxHeight = Integer.MIN_VALUE;
                double topBlockLight = 0.0;
                columnColor.set(0.0f, 0.0f, 0.0f, 0.0f, true);
                if (this.renderSettings.isInsideRenderBoundaries(x, z)) {
                    int maxY;
                    Chunk chunk = world.getChunkAtBlock(x, z);
                    int minY = Math.max(modelMin.getY(), chunk.getMinY(x, z));
                    for (int y = maxY = Math.min(modelMax.getY(), chunk.getMaxY(x, z)); y >= minY; --y) {
                        block.set(x, y, z);
                        if (!block.isInsideRenderBounds()) continue;
                        model.initialize();
                        this.blockRenderer.render(block, model, blockColor);
                        topBlockLight = Math.max(topBlockLight, (double)((float)block.getBlockLightLevel() * (1.0f - columnColor.a)));
                        model.translate(x - modelAnchor.getX(), y - modelAnchor.getY(), z - modelAnchor.getZ());
                        if (blockColor.a > 0.0f) {
                            if (maxHeight < y) {
                                maxHeight = y;
                            }
                            columnColor.underlay(blockColor.premultiplied());
                        }
                        if (this.renderSettings.isRenderTopOnly() && (double)blockColor.a > 0.999 && block.getProperties().isCulling()) break;
                    }
                }
                if (maxHeight == Integer.MIN_VALUE) {
                    maxHeight = 0;
                }
                tileMetaConsumer.set(x, z, columnColor, maxHeight, (int)topBlockLight);
            }
        }
    }
}

