/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.map.hires;

import de.bluecolored.bluemap.core.map.hires.TileModel;
import de.bluecolored.bluemap.core.util.math.MatrixM3f;
import de.bluecolored.bluemap.core.util.math.MatrixM4f;

public class TileModelView {
    private TileModel tileModel;
    private int start;
    private int size;

    public TileModelView(TileModel tileModel) {
        this.initialize(tileModel);
    }

    public TileModelView initialize(TileModel hiresTile, int start) {
        this.tileModel = hiresTile;
        this.start = start;
        this.size = hiresTile.size() - start;
        return this;
    }

    public TileModelView initialize(TileModel hiresTile) {
        this.tileModel = hiresTile;
        this.start = hiresTile.size();
        this.size = 0;
        return this;
    }

    public TileModelView initialize(int start) {
        this.start = start;
        this.size = this.tileModel.size() - start;
        return this;
    }

    public TileModelView initialize() {
        this.start = this.tileModel.size();
        this.size = 0;
        return this;
    }

    public TileModelView reset() {
        this.tileModel.reset(this.start);
        this.size = 0;
        return this;
    }

    public int add(int count) {
        int s2 = this.tileModel.add(count);
        if (s2 != this.start + this.size) {
            throw new IllegalStateException("Size of HiresTileModel had external changes since view-initialisation!");
        }
        this.size += count;
        return s2;
    }

    public TileModelView rotate(float angle, float axisX, float axisY, float axisZ) {
        this.tileModel.rotate(this.start, this.size, angle, axisX, axisY, axisZ);
        return this;
    }

    public TileModelView rotateXYZ(float pitch, float yaw, float roll) {
        this.tileModel.rotateXYZ(this.start, this.size, pitch, yaw, roll);
        return this;
    }

    public TileModelView rotateZYX(float pitch, float yaw, float roll) {
        this.tileModel.rotateZYX(this.start, this.size, pitch, yaw, roll);
        return this;
    }

    public TileModelView rotateYXZ(float pitch, float yaw, float roll) {
        this.tileModel.rotateYXZ(this.start, this.size, pitch, yaw, roll);
        return this;
    }

    public TileModelView scale(float sx, float sy, float sz) {
        this.tileModel.scale(this.start, this.size, sx, sy, sz);
        return this;
    }

    public TileModelView translate(float dx, float dy, float dz) {
        this.tileModel.translate(this.start, this.size, dx, dy, dz);
        return this;
    }

    public TileModelView transform(MatrixM3f t2) {
        this.tileModel.transform(this.start, this.size, t2);
        return this;
    }

    public TileModelView transform(float m00, float m01, float m02, float m10, float m11, float m12, float m20, float m21, float m22) {
        this.tileModel.transform(this.start, this.size, m00, m01, m02, m10, m11, m12, m20, m21, m22);
        return this;
    }

    public TileModelView transform(MatrixM4f t2) {
        this.tileModel.transform(this.start, this.size, t2);
        return this;
    }

    public TileModelView transform(float m00, float m01, float m02, float m03, float m10, float m11, float m12, float m13, float m20, float m21, float m22, float m23, float m30, float m31, float m32, float m33) {
        this.tileModel.transform(this.start, this.size, m00, m01, m02, m03, m10, m11, m12, m13, m20, m21, m22, m23, m30, m31, m32, m33);
        return this;
    }

    public TileModelView invertOrientation() {
        this.tileModel.invertOrientation(this.start, this.size);
        return this;
    }

    public TileModel getTileModel() {
        return this.tileModel;
    }

    public int getStart() {
        return this.start;
    }

    public int getSize() {
        return this.size;
    }
}

