/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.map.hires;

import de.bluecolored.bluemap.core.map.TextureGallery;
import de.bluecolored.bluemap.core.map.hires.RenderPass;
import de.bluecolored.bluemap.core.map.hires.RenderPassFactory;
import de.bluecolored.bluemap.core.map.hires.RenderSettings;
import de.bluecolored.bluemap.core.map.hires.block.BlockRenderPass;
import de.bluecolored.bluemap.core.map.hires.entity.EntityRenderPass;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.ResourcePack;
import de.bluecolored.bluemap.core.util.Key;
import de.bluecolored.bluemap.core.util.Keyed;
import de.bluecolored.bluemap.core.util.Registry;

public interface RenderPassType
extends Keyed,
RenderPassFactory {
    public static final RenderPassType BLOCKS = new Impl(Key.bluemap("blocks"), BlockRenderPass::new);
    public static final RenderPassType ENTITIES = new Impl(Key.bluemap("entities"), EntityRenderPass::new);
    public static final Registry<RenderPassType> REGISTRY = new Registry((Keyed[])new RenderPassType[]{BLOCKS, ENTITIES});

    public static class Impl
    implements RenderPassType {
        private final Key key;
        private final RenderPassFactory factory;

        @Override
        public RenderPass create(ResourcePack resourcePack, TextureGallery textureGallery, RenderSettings renderSettings) {
            return this.factory.create(resourcePack, textureGallery, renderSettings);
        }

        public Impl(Key key, RenderPassFactory factory) {
            this.key = key;
            this.factory = factory;
        }

        @Override
        public Key getKey() {
            return this.key;
        }
    }
}

