/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.map.hires;

import com.flowpowered.math.vector.Vector2i;
import com.flowpowered.math.vector.Vector3i;
import de.bluecolored.bluemap.core.logger.Logger;
import de.bluecolored.bluemap.core.map.TextureGallery;
import de.bluecolored.bluemap.core.map.TileMetaConsumer;
import de.bluecolored.bluemap.core.map.hires.ArrayTileModel;
import de.bluecolored.bluemap.core.map.hires.MaxCapacityReachedException;
import de.bluecolored.bluemap.core.map.hires.PRBMWriter;
import de.bluecolored.bluemap.core.map.hires.RenderPass;
import de.bluecolored.bluemap.core.map.hires.RenderPassType;
import de.bluecolored.bluemap.core.map.hires.RenderSettings;
import de.bluecolored.bluemap.core.map.hires.TileModelView;
import de.bluecolored.bluemap.core.map.hires.VoidTileModel;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.ResourcePack;
import de.bluecolored.bluemap.core.storage.GridStorage;
import de.bluecolored.bluemap.core.util.Grid;
import de.bluecolored.bluemap.core.util.math.Color;
import de.bluecolored.bluemap.core.world.World;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;

public class HiresModelManager {
    private final World world;
    private final GridStorage storage;
    private final ThreadLocal<Collection<RenderPass>> renderPasses;
    private final Grid tileGrid;

    public HiresModelManager(World world, GridStorage storage, ResourcePack resourcePack, TextureGallery textureGallery, RenderSettings renderSettings, Grid tileGrid) {
        this.world = world;
        this.storage = storage;
        this.tileGrid = tileGrid;
        List<RenderPassType> renderPassTypes = List.copyOf(RenderPassType.REGISTRY.values());
        this.renderPasses = ThreadLocal.withInitial(() -> renderPassTypes.stream().map(type -> type.create(resourcePack, textureGallery, renderSettings)).toList());
    }

    public void render(Vector2i tile, TileMetaConsumer tileMetaConsumer, boolean save) {
        Vector3i modelMin = new Vector3i(this.tileGrid.getCellMinX(tile.getX()), Integer.MIN_VALUE, this.tileGrid.getCellMinY(tile.getY()));
        Vector3i modelMax = new Vector3i(this.tileGrid.getCellMaxX(tile.getX()), Integer.MAX_VALUE, this.tileGrid.getCellMaxY(tile.getY()));
        Vector3i modelAnchor = new Vector3i(modelMin.getX(), 0, modelMin.getZ());
        if (save) {
            ArrayTileModel model = ArrayTileModel.instancePool().claimInstance();
            TileModelView modelView = new TileModelView(model);
            try {
                for (RenderPass renderPass : this.renderPasses.get()) {
                    renderPass.render(this.world, modelMin, modelMax, modelAnchor, modelView.initialize(), tileMetaConsumer);
                }
            }
            catch (MaxCapacityReachedException ex) {
                Logger.global.noFloodWarning("max-capacity-reached", "One or more map-tiles are too complex to be completed (@~ %s to %s): %s".formatted(modelMin, modelMax, ex));
            }
            model.sort();
            this.save(model, tile);
            ArrayTileModel.instancePool().recycleInstance(model);
        } else {
            TileModelView modelView = new TileModelView(VoidTileModel.INSTANCE);
            for (RenderPass renderPass : this.renderPasses.get()) {
                renderPass.render(this.world, modelMin, modelMax, modelAnchor, modelView.initialize(), tileMetaConsumer);
            }
        }
    }

    public void unrender(Vector2i tile, TileMetaConsumer tileMetaConsumer) {
        try {
            this.storage.delete(tile.getX(), tile.getY());
        }
        catch (IOException ex) {
            Logger.global.logError("Failed to delete hires model: " + String.valueOf(tile), ex);
        }
        Color color = new Color();
        this.tileGrid.forEachIntersecting(tile, Grid.UNIT, (x, z) -> tileMetaConsumer.set(x, z, color, 0, 0));
    }

    private void save(ArrayTileModel model, Vector2i tile) {
        try (OutputStream out = this.storage.write(tile.getX(), tile.getY());
             PRBMWriter modelWriter = new PRBMWriter(out);){
            modelWriter.write(model);
        }
        catch (IOException e) {
            Logger.global.logError("Failed to save hires model: " + String.valueOf(tile), e);
        }
    }

    public Grid getTileGrid() {
        return this.tileGrid;
    }
}

