/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.map;

import com.flowpowered.math.vector.Vector2i;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import de.bluecolored.bluemap.api.gson.MarkerGson;
import de.bluecolored.bluemap.api.markers.MarkerSet;
import de.bluecolored.bluemap.core.logger.Logger;
import de.bluecolored.bluemap.core.map.MapSettings;
import de.bluecolored.bluemap.core.map.MapSettingsSerializer;
import de.bluecolored.bluemap.core.map.TextureGallery;
import de.bluecolored.bluemap.core.map.hires.HiresModelManager;
import de.bluecolored.bluemap.core.map.lowres.LowresTileManager;
import de.bluecolored.bluemap.core.map.renderstate.MapChunkState;
import de.bluecolored.bluemap.core.map.renderstate.MapTileState;
import de.bluecolored.bluemap.core.resources.adapter.ResourcesGson;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.ResourcePack;
import de.bluecolored.bluemap.core.storage.MapStorage;
import de.bluecolored.bluemap.core.storage.compression.CompressedInputStream;
import de.bluecolored.bluemap.core.util.Grid;
import de.bluecolored.bluemap.core.world.World;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;

public class BmMap {
    private static final Gson GSON = ResourcesGson.addAdapter(new GsonBuilder()).setFieldNamingPolicy(FieldNamingPolicy.IDENTITY).registerTypeAdapter(BmMap.class, (Object)new MapSettingsSerializer()).create();
    private final String id;
    private final String name;
    private final World world;
    private final MapStorage storage;
    private final MapSettings mapSettings;
    private final ResourcePack resourcePack;
    private final TextureGallery textureGallery;
    private final MapTileState mapTileState;
    private final MapChunkState mapChunkState;
    private final HiresModelManager hiresModelManager;
    private final LowresTileManager lowresTileManager;
    private final ConcurrentHashMap<String, MarkerSet> markerSets;
    private Predicate<Vector2i> tileFilter;
    private long renderTimeSumNanos;
    private long tilesRendered;
    private long lastSaveTime;

    public BmMap(String id, String name, World world, MapStorage storage, ResourcePack resourcePack, MapSettings settings) throws IOException, InterruptedException {
        this.id = Objects.requireNonNull(id);
        this.name = Objects.requireNonNull(name);
        this.world = Objects.requireNonNull(world);
        this.storage = Objects.requireNonNull(storage);
        this.resourcePack = Objects.requireNonNull(resourcePack);
        this.mapSettings = Objects.requireNonNull(settings);
        Logger.global.logDebug("Loading render-state for map '" + id + "'");
        this.mapTileState = new MapTileState(storage.tileState());
        this.mapChunkState = new MapChunkState(storage.chunkState());
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Logger.global.logDebug("Loading textures for map '" + id + "'");
        this.textureGallery = this.loadTextureGallery();
        this.textureGallery.put(resourcePack.getTextures());
        this.saveTextureGallery();
        this.hiresModelManager = new HiresModelManager(world, storage.hiresTiles(), this.resourcePack, this.textureGallery, settings, new Grid(settings.getHiresTileSize(), 2));
        this.lowresTileManager = new LowresTileManager(storage, new Grid(settings.getLowresTileSize()), settings.getLodCount(), settings.getLodFactor());
        this.tileFilter = t2 -> true;
        this.markerSets = new ConcurrentHashMap();
        this.renderTimeSumNanos = 0L;
        this.tilesRendered = 0L;
        this.lastSaveTime = -1L;
        this.saveMapSettings();
    }

    public void renderTile(Vector2i tile) {
        if (!this.tileFilter.test(tile)) {
            return;
        }
        long start = System.nanoTime();
        this.hiresModelManager.render(tile, this.lowresTileManager, this.mapSettings.isSaveHiresLayer());
        long end = System.nanoTime();
        long delta = end - start;
        this.renderTimeSumNanos += delta;
        ++this.tilesRendered;
    }

    public void unrenderTile(Vector2i tile) {
        this.hiresModelManager.unrender(tile, this.lowresTileManager);
    }

    public synchronized boolean save(long minTimeSinceLastSave) {
        long now = System.currentTimeMillis();
        if (now - this.lastSaveTime < minTimeSinceLastSave) {
            return false;
        }
        this.save();
        return true;
    }

    public synchronized void save() {
        this.lowresTileManager.save();
        this.mapTileState.save();
        this.mapChunkState.save();
        this.saveMarkerState();
        this.savePlayerState();
        this.saveMapSettings();
        try {
            if (!this.storage.textures().exists()) {
                this.saveTextureGallery();
            }
        }
        catch (IOException e) {
            Logger.global.logError("Failed to read texture gallery for map '" + this.getId() + "'!", e);
        }
        this.lastSaveTime = System.currentTimeMillis();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private TextureGallery loadTextureGallery() throws IOException {
        try (CompressedInputStream in = this.storage.textures().read();){
            if (in == null) return new TextureGallery();
            TextureGallery textureGallery = TextureGallery.readTexturesFile(in.decompress());
            return textureGallery;
        }
        catch (IOException ex) {
            Logger.global.logError("Failed to load textures for map '" + this.getId() + "'!", ex);
        }
        return new TextureGallery();
    }

    private void saveTextureGallery() {
        try (OutputStream out = this.storage.textures().write();){
            this.textureGallery.writeTexturesFile(out);
        }
        catch (IOException ex) {
            Logger.global.logError("Failed to save textures for map '" + this.getId() + "'!", ex);
        }
    }

    public synchronized void resetTextureGallery() {
        this.textureGallery.clear();
        this.textureGallery.put(this.resourcePack.getTextures());
    }

    private void saveMapSettings() {
        try (OutputStream out = this.storage.settings().write();
             OutputStreamWriter writer = new OutputStreamWriter(out, StandardCharsets.UTF_8);){
            GSON.toJson((Object)this, (Appendable)writer);
        }
        catch (Exception ex) {
            Logger.global.logError("Failed to save settings for map '" + this.getId() + "'!", ex);
        }
    }

    public synchronized void saveMarkerState() {
        try (OutputStream out = this.storage.markers().write();
             OutputStreamWriter writer = new OutputStreamWriter(out, StandardCharsets.UTF_8);){
            MarkerGson.INSTANCE.toJson(this.markerSets, (Appendable)writer);
        }
        catch (Exception ex) {
            Logger.global.logError("Failed to save markers for map '" + this.getId() + "'!", ex);
        }
    }

    public synchronized void savePlayerState() {
        try (OutputStream out = this.storage.players().write();){
            out.write("{}".getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception ex) {
            Logger.global.logError("Failed to save markers for map '" + this.getId() + "'!", ex);
        }
    }

    public long getAverageNanosPerTile() {
        return this.renderTimeSumNanos / this.tilesRendered;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof BmMap) {
            BmMap that = (BmMap)obj;
            return this.id.equals(that.id);
        }
        return false;
    }

    public String toString() {
        return "BmMap{id='" + this.id + "', name='" + this.name + "', world=" + String.valueOf(this.world) + ", storage=" + String.valueOf(this.storage) + "}";
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public World getWorld() {
        return this.world;
    }

    public MapStorage getStorage() {
        return this.storage;
    }

    public MapSettings getMapSettings() {
        return this.mapSettings;
    }

    public ResourcePack getResourcePack() {
        return this.resourcePack;
    }

    public TextureGallery getTextureGallery() {
        return this.textureGallery;
    }

    public MapTileState getMapTileState() {
        return this.mapTileState;
    }

    public MapChunkState getMapChunkState() {
        return this.mapChunkState;
    }

    public HiresModelManager getHiresModelManager() {
        return this.hiresModelManager;
    }

    public LowresTileManager getLowresTileManager() {
        return this.lowresTileManager;
    }

    public ConcurrentHashMap<String, MarkerSet> getMarkerSets() {
        return this.markerSets;
    }

    public Predicate<Vector2i> getTileFilter() {
        return this.tileFilter;
    }

    public void setTileFilter(Predicate<Vector2i> tileFilter) {
        this.tileFilter = tileFilter;
    }
}

