/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core;

import de.bluecolored.bluemap.core.logger.Logger;
import de.bluecolored.shadow.configurate.gson.GsonConfigurationLoader;
import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.ScheduledExecutorService;

public class BlueMap {
    public static final String VERSION;
    public static final String GIT_HASH;
    public static final ForkJoinPool THREAD_POOL;
    private static final Thread.Builder.OfPlatform schedulerThreadBuilder;
    public static final ScheduledExecutorService SCHEDULER;

    static {
        String version = "DEV";
        String gitHash = "DEV";
        try {
            Object node = ((GsonConfigurationLoader.Builder)GsonConfigurationLoader.builder().url(BlueMap.class.getResource("/de/bluecolored/bluemap/version.json"))).build().load();
            version = node.node("version").getString("DEV");
            gitHash = node.node("git-hash").getString("DEV");
        }
        catch (IOException ex) {
            Logger.global.logError("Failed to load version.json from resources!", ex);
        }
        if (version.equals("${version}")) {
            version = "DEV";
        }
        if (gitHash.equals("${gitHash}")) {
            version = "DEV";
        }
        VERSION = version;
        GIT_HASH = gitHash;
        THREAD_POOL = new ForkJoinPool(Runtime.getRuntime().availableProcessors(), pool -> {
            ForkJoinWorkerThread thread = ForkJoinPool.defaultForkJoinWorkerThreadFactory.newThread(pool);
            thread.setContextClassLoader(BlueMap.class.getClassLoader());
            thread.setName("BlueMap-FJP-" + thread.getPoolIndex());
            return thread;
        }, null, false);
        schedulerThreadBuilder = Thread.ofPlatform().name("BlueMap-Scheduler-", 0L);
        SCHEDULER = Executors.newScheduledThreadPool(1, runnable -> {
            Thread thread = schedulerThreadBuilder.unstarted(runnable);
            thread.setContextClassLoader(BlueMap.class.getClassLoader());
            return thread;
        });
    }
}

