/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.web.http;

import de.bluecolored.bluemap.common.web.http.SelectionConsumer;
import de.bluecolored.bluemap.core.logger.Logger;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;

public abstract class Server
extends Thread
implements Closeable,
Runnable {
    private final Selector selector = Selector.open();
    private final Collection<ServerSocketChannel> server = new ArrayList<ServerSocketChannel>();

    public Server(String name) throws IOException {
        super(name);
    }

    public abstract SelectionConsumer createConnectionHandler();

    public void bind(SocketAddress address) throws IOException {
        ServerSocketChannel server = ServerSocketChannel.open();
        server.configureBlocking(false);
        server.register(this.selector, 16, this::accept);
        server.bind(address);
        this.server.add(server);
        if (this.checkIfBoundToAllInterfaces(address)) {
            Logger.global.logInfo("WebServer bound to all network interfaces on port " + ((InetSocketAddress)server.getLocalAddress()).getPort());
        } else {
            Logger.global.logInfo("WebServer bound to: " + String.valueOf(server.getLocalAddress()));
        }
    }

    private boolean checkIfBoundToAllInterfaces(SocketAddress address) {
        if (address instanceof InetSocketAddress) {
            InetSocketAddress inetAddress = (InetSocketAddress)address;
            return Objects.equals(inetAddress.getAddress(), new InetSocketAddress(0).getAddress());
        }
        return false;
    }

    @Override
    public void run() {
        Logger.global.logInfo("WebServer started.");
        while (this.selector.isOpen()) {
            try {
                this.selector.select(this::selection);
            }
            catch (IOException e) {
                Logger.global.logDebug("Failed to select channel: " + String.valueOf(e));
            }
            catch (ClosedSelectorException closedSelectorException) {}
        }
    }

    private void selection(SelectionKey selectionKey) {
        Object attachment = selectionKey.attachment();
        if (attachment instanceof SelectionConsumer) {
            ((SelectionConsumer)attachment).accept(selectionKey);
        }
    }

    private void accept(SelectionKey selectionKey) {
        try {
            ServerSocketChannel serverSocketChannel = (ServerSocketChannel)selectionKey.channel();
            SocketChannel channel = serverSocketChannel.accept();
            if (channel == null) {
                return;
            }
            channel.configureBlocking(false);
            channel.register(this.selector, 5, this.createConnectionHandler());
        }
        catch (IOException e) {
            Logger.global.logDebug("Failed to accept connection: " + String.valueOf(e));
        }
    }

    @Override
    public void close() throws IOException {
        IOException exception = null;
        try {
            this.selector.close();
            this.selector.wakeup();
        }
        catch (IOException ex) {
            exception = ex;
        }
        for (ServerSocketChannel server : this.server) {
            try {
                server.close();
            }
            catch (IOException ex) {
                if (exception == null) {
                    exception = ex;
                    continue;
                }
                exception.addSuppressed(ex);
            }
        }
        if (exception != null) {
            throw exception;
        }
    }
}

