/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.plugin.skins;

import de.bluecolored.bluemap.api.plugin.PlayerIconFactory;
import de.bluecolored.bluemap.api.plugin.SkinProvider;
import de.bluecolored.bluemap.common.plugin.Plugin;
import de.bluecolored.bluemap.common.plugin.skins.DefaultPlayerIconFactory;
import de.bluecolored.bluemap.common.plugin.skins.MojangSkinProvider;
import de.bluecolored.bluemap.common.serverinterface.ServerEventListener;
import de.bluecolored.bluemap.core.BlueMap;
import de.bluecolored.bluemap.core.logger.Logger;
import de.bluecolored.bluemap.core.map.BmMap;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;

public class PlayerSkinUpdater
implements ServerEventListener {
    private final Plugin plugin;
    private final Map<UUID, Long> skinUpdates;
    private SkinProvider skinProvider;
    private PlayerIconFactory playerMarkerIconFactory;

    public PlayerSkinUpdater(Plugin plugin) {
        this.plugin = plugin;
        this.skinUpdates = new ConcurrentHashMap<UUID, Long>();
        this.skinProvider = new MojangSkinProvider();
        this.playerMarkerIconFactory = new DefaultPlayerIconFactory();
    }

    public CompletableFuture<Void> updateSkin(UUID playerUuid) {
        long lastUpdate = this.skinUpdates.getOrDefault(playerUuid, 0L);
        long now = System.currentTimeMillis();
        if (now - lastUpdate < TimeUnit.HOURS.toMillis(1L)) {
            return CompletableFuture.completedFuture(null);
        }
        this.skinUpdates.put(playerUuid, now);
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.skinProvider.load(playerUuid);
            }
            catch (IOException e) {
                throw new CompletionException("The skin provider threw an exception while loading the skin for UUID: '" + String.valueOf(playerUuid) + "'!", e);
            }
        }, BlueMap.THREAD_POOL).thenAcceptAsync(skin -> {
            Map<String, BmMap> maps = this.plugin.getBlueMap().getMaps();
            if (maps == null) {
                Logger.global.logDebug("Could not update skin, since the plugin seems not to be ready.");
                return;
            }
            if (skin.isEmpty()) {
                Logger.global.logDebug("Empty player-skin provided for UUID: " + String.valueOf(playerUuid));
                for (BmMap map : maps.values()) {
                    try {
                        map.getStorage().asset("playerheads/" + String.valueOf(playerUuid) + ".png").delete();
                    }
                    catch (IOException ex) {
                        Logger.global.logError("Failed to remove player skin from storage: " + String.valueOf(playerUuid), ex);
                    }
                }
                return;
            }
            BufferedImage playerHead = this.playerMarkerIconFactory.apply(playerUuid, (BufferedImage)skin.get());
            for (BmMap map : maps.values()) {
                try {
                    OutputStream out = map.getStorage().asset("playerheads/" + String.valueOf(playerUuid) + ".png").write();
                    try {
                        ImageIO.write((RenderedImage)playerHead, "png", out);
                    }
                    finally {
                        if (out == null) continue;
                        out.close();
                    }
                }
                catch (IOException ex) {
                    Logger.global.logError("Failed to write player skin to storage: " + String.valueOf(playerUuid), ex);
                }
            }
        }, (Executor)BlueMap.THREAD_POOL);
    }

    @Override
    public void onPlayerJoin(UUID playerUuid) {
        this.updateSkin(playerUuid).exceptionally(ex -> {
            Logger.global.logError("Failed to update player skin: " + String.valueOf(playerUuid), (Throwable)ex);
            return null;
        });
    }

    public SkinProvider getSkinProvider() {
        return this.skinProvider;
    }

    public void setSkinProvider(SkinProvider skinProvider) {
        this.skinProvider = Objects.requireNonNull(skinProvider, "skinProvider can not be null");
    }

    public PlayerIconFactory getPlayerMarkerIconFactory() {
        return this.playerMarkerIconFactory;
    }

    public void setPlayerMarkerIconFactory(PlayerIconFactory playerMarkerIconFactory) {
        this.playerMarkerIconFactory = Objects.requireNonNull(playerMarkerIconFactory, "playerMarkerIconFactory can not be null");
    }
}

