/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.config;

import de.bluecolored.bluemap.core.logger.Logger;

public class ConfigurationException
extends Exception {
    private static final String FORMATTING_BAR = "################################";
    private final String explanation;

    public ConfigurationException(String explanation) {
        this.explanation = explanation;
    }

    public ConfigurationException(String message, String explanation) {
        super(message);
        this.explanation = explanation;
    }

    public ConfigurationException(String explanation, Throwable cause) {
        super(cause);
        this.explanation = explanation;
    }

    public ConfigurationException(String message, String explanation, Throwable cause) {
        super(message, cause);
        this.explanation = explanation;
    }

    public Throwable getRootCause() {
        Throwable cause = this;
        while ((cause = cause.getCause()) instanceof ConfigurationException) {
        }
        return cause;
    }

    public String getExplanation() {
        return this.explanation;
    }

    public String getFullExplanation() {
        Throwable cause;
        for (cause = this.getCause(); cause != null && !(cause instanceof ConfigurationException); cause = cause.getCause()) {
        }
        if (cause != null) {
            return this.getExplanation() + "\n\n" + ((ConfigurationException)cause).getFullExplanation();
        }
        return this.getExplanation();
    }

    public String getFormattedExplanation() {
        String indentedExplanation = " " + this.getFullExplanation().replace("\n", "\n ");
        return "\n################################\n There is a problem with your BlueMap setup!\n\n" + indentedExplanation + "\n################################";
    }

    public void printLog(Logger logger) {
        logger.logWarning(this.getFormattedExplanation());
        Throwable cause = this.getRootCause();
        if (cause != null) {
            logger.logError("Detailed error:", this);
        }
    }
}

