/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.commands.checks;

import de.bluecolored.bluemap.common.BlueMapConfiguration;
import de.bluecolored.bluemap.common.commands.TextFormat;
import de.bluecolored.bluemap.common.commands.checks.Check;
import de.bluecolored.bluemap.common.commands.checks.CheckResult;
import de.bluecolored.bluemap.common.config.BlueMapConfigManager;
import de.bluecolored.bluemap.common.plugin.Plugin;
import de.bluecolored.bluemap.common.serverinterface.ServerWorld;
import de.bluecolored.bluemap.core.map.BmMap;
import de.bluecolored.bluemap.core.world.World;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.HoverEventSource;

public class MapHasCorrectWorldCheck
implements Check {
    private final Plugin plugin;
    private final BmMap map;
    private final ServerWorld expectedWorld;

    public String getExpectedWorldId() {
        return World.id(this.expectedWorld.getWorldFolder(), this.expectedWorld.getDimension());
    }

    @Override
    public CheckResult getResult() {
        return this.map.getWorld().getId().equals(this.getExpectedWorldId()) ? CheckResult.OK : CheckResult.BAD;
    }

    @Override
    public Component getFailureDescription() {
        return TextFormat.lines(new Component[]{TextFormat.format("\u26a0 map % is configured for\nworld % instead of\nworld %\n".strip(), TextFormat.formatMap(this.map).color(TextFormat.HIGHLIGHT_COLOR), Component.text((String)this.map.getWorld().getId()).color(TextFormat.HIGHLIGHT_COLOR), Component.text((String)this.getExpectedWorldId()).color(TextFormat.HIGHLIGHT_COLOR)), Component.empty(), this.mapWorldConfigInfo()});
    }

    private Component mapWorldConfigInfo() {
        return TextFormat.format("to configure the map for your current world,\nmake sure to set\n%\nin the % config file\n".strip(), this.formatWorldConfig().color(TextFormat.INFO_COLOR), this.formatConfigFilePath("maps/" + this.map.getId()).color(TextFormat.HIGHLIGHT_COLOR)).color(TextFormat.BASE_COLOR);
    }

    private Component formatWorldConfig() {
        return TextFormat.format("\u250c\n\u2502 world: \"%\"\n\u2502 dimension: \"%\"\n\u2514\n".strip(), BlueMapConfigManager.formatPath(this.expectedWorld.getWorldFolder()), this.expectedWorld.getDimension().getFormatted());
    }

    private Component formatConfigFilePath(String name) {
        TextComponent format = Component.text((String)(name + ".conf"));
        BlueMapConfiguration blueMapConfiguration = this.plugin.getBlueMap().getConfig();
        if (blueMapConfiguration instanceof BlueMapConfigManager) {
            BlueMapConfigManager configManager = (BlueMapConfigManager)blueMapConfiguration;
            format = format.hoverEvent((HoverEventSource)Component.text((String)BlueMapConfigManager.formatPath(configManager.getConfigManager().resolveConfigFile(name))));
        }
        return format;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public BmMap getMap() {
        return this.map;
    }

    public ServerWorld getExpectedWorld() {
        return this.expectedWorld;
    }

    public MapHasCorrectWorldCheck(Plugin plugin, BmMap map, ServerWorld expectedWorld) {
        this.plugin = plugin;
        this.map = map;
        this.expectedWorld = expectedWorld;
    }
}

