/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.commands;

import de.bluecolored.bluemap.core.map.BmMap;
import java.lang.runtime.SwitchBootstraps;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.StreamSupport;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentIteratorFlag;
import net.kyori.adventure.text.ComponentIteratorType;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.JoinConfiguration;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TextReplacementConfig;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.jetbrains.annotations.Nullable;

public final class TextFormat {
    private static final Pattern NEWLINE_PATTERN = Pattern.compile("\\n");
    private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("%");
    private static final String DETAILS_ITEM = "\u251c ";
    private static final String DETAILS_LINE = "\u2502 ";
    private static final String DETAILS_END = "\u2514 ";
    private static final String DETAILS_INDENT = "\u00a0 ";
    private static final TemporalUnit[] DURATION_UNITS = new TemporalUnit[]{ChronoUnit.DAYS, ChronoUnit.HOURS, ChronoUnit.MINUTES, ChronoUnit.SECONDS};
    public static final TextColor BASE_COLOR = TextColor.color((int)0xAAAAAA);
    public static final TextColor HIGHLIGHT_COLOR = TextColor.color((int)0xFFFFFF);
    public static final TextColor TITLE_COLOR = TextColor.color((int)0x4488FF);
    public static final TextColor POSITIVE_COLOR = TextColor.color((int)0x88FF88);
    public static final TextColor NEGATIVE_COLOR = TextColor.color((int)0xFF8888);
    public static final TextColor INFO_COLOR = TextColor.color((int)0xFFFF88);
    public static final TextColor WARNING_COLOR = TextColor.color((int)0xFF8844);
    public static final TextColor FROZEN_COLOR = TextColor.color((int)0xAACCFF);
    public static final Component ICON_UPDATED = Component.text((String)"\u2714").color(POSITIVE_COLOR);
    public static final Component ICON_FROZEN = Component.text((String)"\u2744").color(FROZEN_COLOR);
    public static final Component ICON_PENDING = Component.text((String)"\u231b").color(INFO_COLOR);
    public static final Component ICON_IN_PROGRESS = Component.text((String)"\u26cf").color(INFO_COLOR);
    public static final Component ICON_STOPPED = Component.text((String)"\u274c").color(NEGATIVE_COLOR);
    public static final DateTimeFormatter DATE_TIME_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    public static final String DISCORD_LINK = "https://discord.gg/zmkyJa3";
    public static final String WIKI_LINK = "https://bluemap.bluecolored.de/wiki/";
    public static final String WIKI_LINK_RENDER_MASKS = "https://bluemap.bluecolored.de/wiki/customization/Masks.html";

    public static Component paragraph(TextColor color, Component title, Component content) {
        return TextFormat.lines(TextFormat.format("BlueMap % >", title).color(color).decorate(TextDecoration.BOLD), TextFormat.indent(content, (Component)Component.space()));
    }

    public static Component paragraph(String title, Component content) {
        return TextFormat.paragraph(TITLE_COLOR, ((TextComponent)Component.text((String)title).color(HIGHLIGHT_COLOR)).decoration(TextDecoration.BOLD, false), content);
    }

    public static Component details(TextColor color, Collection<Component> components) {
        return TextFormat.details(color, (Component[])components.toArray(Component[]::new));
    }

    public static Component details(TextColor color, Component ... components) {
        if (components.length == 0) {
            return Component.empty();
        }
        TextComponent end = Component.text((String)DETAILS_END, (TextColor)color);
        TextComponent indent = Component.text((String)DETAILS_INDENT, (TextColor)color);
        if (components.length == 1) {
            return TextFormat.indent(components[0], (Component)end, (Component)indent);
        }
        TextComponent item = Component.text((String)DETAILS_ITEM, (TextColor)color);
        TextComponent line = Component.text((String)DETAILS_LINE, (TextColor)color);
        TextComponent result = Component.empty();
        for (int i = 0; i < components.length - 1; ++i) {
            result = result.append(TextFormat.indent(components[i], (Component)item, (Component)line)).append((Component)Component.newline());
        }
        return result.append(TextFormat.indent(components[components.length - 1], (Component)end, (Component)indent));
    }

    public static Component format(String format, Object ... placeholders) {
        return TextFormat.format((Component)Component.text((String)format), Arrays.asList(placeholders));
    }

    public static Component format(Component format, Object ... placeholders) {
        return TextFormat.format(format, Arrays.asList(placeholders));
    }

    public static Component format(Component format, Iterable<Object> placeholders) {
        Iterator<Object> iterator = placeholders.iterator();
        return format.replaceText((TextReplacementConfig)TextReplacementConfig.builder().match(PLACEHOLDER_PATTERN).replacement(match -> iterator.hasNext() ? TextFormat.toComponent(iterator.next()) : null).build());
    }

    public static Component item(String key, Object value) {
        return TextFormat.item(key, (ComponentLike)Component.text((String)value.toString()).color(HIGHLIGHT_COLOR));
    }

    public static Component item(String key, ComponentLike value) {
        return TextFormat.format("%: %", key, value).color(BASE_COLOR);
    }

    public static Component toComponent(Object object) {
        Object object2 = object;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ComponentLike.class}, (Object)object2, n)) {
            case 0 -> {
                ComponentLike cl = (ComponentLike)object2;
                yield cl.asComponent();
            }
            case -1 -> Component.text((String)"null");
            default -> Component.text((String)object.toString());
        };
    }

    public static Component indent(Component component, Component indent) {
        return TextFormat.indent(component, indent, indent);
    }

    public static Component indent(Component component, Component firstIndent, Component indent) {
        Component newlineIndent = Component.newline().append(indent);
        return firstIndent.append(component.replaceText((TextReplacementConfig)TextReplacementConfig.builder().match(NEWLINE_PATTERN).replacement((ComponentLike)newlineIndent).build()));
    }

    public static Component lines(Iterable<@Nullable Component> lines) {
        return Component.join((JoinConfiguration)JoinConfiguration.newlines(), StreamSupport.stream(lines.spliterator(), true).filter(Objects::nonNull).toList());
    }

    public static Component lines(Component ... lines) {
        return TextFormat.lines(Arrays.asList(lines));
    }

    public static Component command(String command) {
        return ((TextComponent)Component.text((String)command).clickEvent(ClickEvent.runCommand((String)command))).hoverEvent((HoverEventSource)TextFormat.format("Click to run %", Component.text((String)command).color(HIGHLIGHT_COLOR)).color(BASE_COLOR));
    }

    public static int lineCount(Component component) {
        int lines = 1;
        for (Component c : component.iterable(ComponentIteratorType.BREADTH_FIRST, new ComponentIteratorFlag[0])) {
            TextComponent text;
            if (!(c instanceof TextComponent) || !(text = (TextComponent)c).content().contains("\n")) continue;
            ++lines;
        }
        return lines;
    }

    public static Component[] stripNulls(Component ... elements) {
        return (Component[])Arrays.stream(elements).filter(Objects::nonNull).toArray(Component[]::new);
    }

    public static String duration(Instant since) {
        return TextFormat.duration(Duration.between(since, Instant.now()));
    }

    public static String duration(Duration duration) {
        TemporalUnit etaUnit;
        long durationMillis = duration.toMillis();
        double value = durationMillis;
        TemporalUnit unit = ChronoUnit.MILLIS;
        TemporalUnit[] temporalUnitArray = DURATION_UNITS;
        int n = temporalUnitArray.length;
        for (int i = 0; i < n && !((value = (double)durationMillis / (double)(unit = (etaUnit = temporalUnitArray[i])).getDuration().toMillis()) > 1.0); ++i) {
        }
        if (value < 2.0 && unit != ChronoUnit.SECONDS) {
            return String.format("%.1f %s", value, unit.toString().toLowerCase(Locale.ROOT));
        }
        return String.format("%.0f %s", value, unit.toString().toLowerCase(Locale.ROOT));
    }

    public static Component durationFormat(Instant since) {
        LocalDateTime time = LocalDateTime.ofInstant(since, ZoneId.systemDefault());
        return ((TextComponent)Component.text((String)TextFormat.duration(since)).color(HIGHLIGHT_COLOR)).hoverEvent((HoverEventSource)Component.text((String)DATE_TIME_FORMAT.format(time)));
    }

    public static Component formatMap(BmMap map) {
        return Component.text((String)map.getId()).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)map.getName())));
    }

    private TextFormat() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

