/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.api;

import com.flowpowered.math.vector.Vector2i;
import de.bluecolored.bluemap.api.BlueMapMap;
import de.bluecolored.bluemap.common.api.BlueMapAPIImpl;
import de.bluecolored.bluemap.common.api.BlueMapMapImpl;
import de.bluecolored.bluemap.common.plugin.Plugin;
import de.bluecolored.bluemap.common.rendermanager.MapPurgeTask;
import de.bluecolored.bluemap.common.rendermanager.MapUpdatePreparationTask;
import de.bluecolored.bluemap.common.rendermanager.MapUpdateTask;
import de.bluecolored.bluemap.common.rendermanager.RenderManager;
import de.bluecolored.bluemap.common.rendermanager.TileUpdateStrategy;
import java.util.Collection;
import lombok.NonNull;

public class RenderManagerImpl
implements de.bluecolored.bluemap.api.RenderManager {
    private final BlueMapAPIImpl api;
    private final Plugin plugin;
    private final RenderManager renderManager;

    public RenderManagerImpl(BlueMapAPIImpl api, Plugin plugin) {
        this.api = api;
        this.plugin = plugin;
        this.renderManager = plugin.getRenderManager();
    }

    @Override
    public boolean scheduleMapUpdateTask(@NonNull BlueMapMap map, boolean force) {
        if (map == null) {
            throw new NullPointerException("map is marked non-null but is null");
        }
        BlueMapMapImpl cmap = this.castMap(map);
        return this.renderManager.scheduleRenderTask(MapUpdatePreparationTask.updateMap(cmap.map(), TileUpdateStrategy.fixed(force), this.renderManager));
    }

    @Override
    public boolean scheduleMapUpdateTask(@NonNull BlueMapMap map, Collection<Vector2i> regions, boolean force) {
        if (map == null) {
            throw new NullPointerException("map is marked non-null but is null");
        }
        BlueMapMapImpl cmap = this.castMap(map);
        return this.renderManager.scheduleRenderTask(new MapUpdateTask(cmap.map(), regions, TileUpdateStrategy.fixed(force)));
    }

    @Override
    public boolean scheduleMapPurgeTask(@NonNull BlueMapMap map) {
        if (map == null) {
            throw new NullPointerException("map is marked non-null but is null");
        }
        BlueMapMapImpl cmap = this.castMap(map);
        return this.renderManager.scheduleRenderTask(new MapPurgeTask(cmap.map()));
    }

    @Override
    public int renderQueueSize() {
        return this.renderManager.getScheduledRenderTaskCount();
    }

    @Override
    public int renderThreadCount() {
        return this.renderManager.getWorkerThreadCount();
    }

    @Override
    public boolean isRunning() {
        return this.renderManager.isRunning();
    }

    @Override
    public void start() {
        this.start(this.plugin.getBlueMap().getConfig().getCoreConfig().resolveRenderThreadCount());
    }

    @Override
    public void start(int threadCount) {
        if (!this.isRunning()) {
            this.renderManager.start(threadCount, this.plugin.getBlueMap().getConfig().getCoreConfig().getRenderThreadPriority());
        }
        this.plugin.getPluginState().setRenderThreadsEnabled(true);
    }

    @Override
    public void stop() {
        this.renderManager.stop();
        this.plugin.getPluginState().setRenderThreadsEnabled(false);
    }

    private BlueMapMapImpl castMap(BlueMapMap map) {
        BlueMapMapImpl cmap = map instanceof BlueMapMapImpl ? (BlueMapMapImpl)map : (BlueMapMapImpl)this.api.getMap(map.getId()).orElseThrow(() -> new IllegalStateException("Failed to get BlueMapMapImpl for map " + map.getId()));
        return cmap;
    }
}

