/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.bukkit;

import de.bluecolored.bluemap.bukkit.BukkitPlugin;
import de.bluecolored.bluemap.bukkit.FoliaSupport;
import de.bluecolored.bluemap.common.serverinterface.ServerWorld;
import de.bluecolored.bluemap.core.resources.pack.datapack.DataPack;
import de.bluecolored.bluemap.core.util.Key;
import de.bluecolored.bluemap.core.world.mca.MCAWorld;
import java.lang.ref.WeakReference;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;

public class BukkitWorld
implements ServerWorld {
    private final WeakReference<World> delegate;
    private final Path worldFolder;
    private final Key dimension;

    public BukkitWorld(World delegate) {
        this.delegate = new WeakReference<World>(delegate);
        Path worldFolder = delegate.getWorldFolder().toPath();
        this.dimension = switch (delegate.getEnvironment()) {
            case World.Environment.NORMAL -> DataPack.DIMENSION_OVERWORLD;
            case World.Environment.NETHER -> DataPack.DIMENSION_THE_NETHER;
            case World.Environment.THE_END -> DataPack.DIMENSION_THE_END;
            default -> {
                net.kyori.adventure.key.Key id = delegate.key();
                yield new Key(id.namespace(), id.value());
            }
        };
        Path dimensionFolder = MCAWorld.resolveDimensionFolder(worldFolder, this.dimension);
        if (!Files.exists(dimensionFolder, new LinkOption[0])) {
            Path dimensionSubPath = worldFolder.relativize(dimensionFolder);
            if (Files.exists(worldFolder, new LinkOption[0]) && worldFolder.endsWith(dimensionSubPath)) {
                worldFolder = worldFolder.subpath(0, worldFolder.getNameCount() - dimensionSubPath.getNameCount());
            }
        }
        this.worldFolder = worldFolder;
    }

    @Override
    public boolean persistWorldChanges() {
        World world;
        if (!FoliaSupport.IS_FOLIA && (world = (World)this.delegate.get()) != null) {
            Executor mainThread = Bukkit.getScheduler().getMainThreadExecutor((Plugin)BukkitPlugin.getInstance());
            CompletableFuture.runAsync(() -> ((World)world).save(), mainThread).join();
            return true;
        }
        return false;
    }

    @Override
    public Path getWorldFolder() {
        return this.worldFolder;
    }

    @Override
    public Key getDimension() {
        return this.dimension;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BukkitWorld that = (BukkitWorld)o;
        Object world = this.delegate.get();
        return world != null && world.equals(that.delegate.get());
    }

    public int hashCode() {
        Object world = this.delegate.get();
        return world != null ? world.hashCode() : 0;
    }
}

