/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.shadow.configurate.gson;

import com.google.gson.stream.JsonReader;
import de.bluecolored.shadow.checkerframework.checker.nullness.qual.Nullable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;

final class JsonReaderAccess {
    static final int VALUE_UNKNOWN = -1;
    private static final @Nullable MethodHandle JSON_READER_POS;
    private static final @Nullable MethodHandle JSON_READER_LINE_NUMBER;
    private static final @Nullable MethodHandle JSON_READER_LINE_START;

    private static @Nullable MethodHandle getter(MethodHandles.Lookup lookup, Class<?> clazz, String name, Class<?> type) throws IllegalAccessException, NoSuchFieldException {
        Field field = clazz.getDeclaredField(name);
        field.setAccessible(true);
        if (!field.getType().equals(type)) {
            return null;
        }
        return lookup.unreflectGetter(field);
    }

    private JsonReaderAccess() {
    }

    static int lineNumber(JsonReader reader) {
        if (JSON_READER_LINE_NUMBER == null) {
            return -1;
        }
        try {
            return JSON_READER_LINE_NUMBER.invoke(reader) + 1;
        }
        catch (Error err) {
            throw err;
        }
        catch (Throwable throwable) {
            return -1;
        }
    }

    static int column(JsonReader reader) {
        if (JSON_READER_POS == null || JSON_READER_LINE_START == null) {
            return -1;
        }
        try {
            int pos = JSON_READER_POS.invoke(reader);
            int lineStart = JSON_READER_LINE_START.invoke(reader);
            return pos - lineStart + 1;
        }
        catch (Error err) {
            throw err;
        }
        catch (Throwable thr) {
            return -1;
        }
    }

    static {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        @Nullable MethodHandle pos = null;
        @Nullable MethodHandle lineNumber = null;
        @Nullable MethodHandle lineStart = null;
        try {
            pos = JsonReaderAccess.getter(lookup, JsonReader.class, "pos", Integer.TYPE);
            lineNumber = JsonReaderAccess.getter(lookup, JsonReader.class, "lineNumber", Integer.TYPE);
            lineStart = JsonReaderAccess.getter(lookup, JsonReader.class, "lineStart", Integer.TYPE);
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            // empty catch block
        }
        JSON_READER_POS = pos;
        JSON_READER_LINE_NUMBER = lineNumber;
        JSON_READER_LINE_START = lineStart;
    }
}

