/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.shadow.caffeine.cache;

import de.bluecolored.shadow.caffeine.cache.AsyncCacheLoader;
import de.bluecolored.shadow.caffeine.cache.Caffeine;
import de.bluecolored.shadow.caffeine.cache.LocalCacheFactory;
import de.bluecolored.shadow.caffeine.cache.Node;
import de.bluecolored.shadow.caffeine.cache.Pacer;
import de.bluecolored.shadow.caffeine.cache.SSL;
import de.bluecolored.shadow.caffeine.cache.Scheduler;
import de.bluecolored.shadow.caffeine.cache.Ticker;
import de.bluecolored.shadow.caffeine.cache.WriteOrderDeque;
import de.bluecolored.shadow.checkerframework.checker.nullness.qual.Nullable;

class SSLW<K, V>
extends SSL<K, V> {
    static final LocalCacheFactory FACTORY = SSLW::new;
    final Ticker ticker;
    final WriteOrderDeque<Node<K, V>> writeOrderDeque;
    volatile long expiresAfterWriteNanos;
    final Pacer pacer;

    SSLW(Caffeine<K, V> caffeine, @Nullable AsyncCacheLoader<? super K, V> asyncCacheLoader, boolean bl) {
        super(caffeine, asyncCacheLoader, bl);
        this.ticker = caffeine.getTicker();
        this.writeOrderDeque = new WriteOrderDeque();
        this.expiresAfterWriteNanos = caffeine.getExpiresAfterWriteNanos();
        this.pacer = caffeine.getScheduler() == Scheduler.disabledScheduler() ? null : new Pacer(caffeine.getScheduler());
    }

    @Override
    public final Ticker expirationTicker() {
        return this.ticker;
    }

    @Override
    protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
        return this.writeOrderDeque;
    }

    @Override
    protected final boolean expiresAfterWrite() {
        return true;
    }

    @Override
    protected final long expiresAfterWriteNanos() {
        return this.expiresAfterWriteNanos;
    }

    @Override
    protected final void setExpiresAfterWriteNanos(long l) {
        this.expiresAfterWriteNanos = l;
    }

    @Override
    public final Pacer pacer() {
        return this.pacer;
    }
}

