/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.world.mca.data;

import com.flowpowered.math.vector.Vector3d;
import de.bluecolored.bluenbt.NBTReader;
import de.bluecolored.bluenbt.TagType;
import de.bluecolored.bluenbt.TypeDeserializer;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;

public class Vector3dDeserializer
implements TypeDeserializer<Vector3d> {
    @Override
    public Vector3d read(NBTReader reader) throws IOException {
        TagType tag;
        TagType tagType = tag = reader.peek();
        int n = 0;
        return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"INT_ARRAY", "LONG_ARRAY", "BYTE_ARRAY", "LIST", "COMPOUND"}, (TagType)tagType, n)) {
            case 0, 1, 2 -> {
                long[] values = reader.nextArrayAsLongArray();
                if (values.length != 3) {
                    throw new IllegalStateException("Unexpected array length: " + values.length);
                }
                yield new Vector3d((float)values[0], (float)values[1], (float)values[2]);
            }
            case 3 -> {
                reader.beginList();
                Vector3d value = new Vector3d(reader.nextDouble(), reader.nextDouble(), reader.nextDouble());
                reader.endList();
                yield value;
            }
            case 4 -> {
                double x = 0.0;
                double y = 0.0;
                double z = 0.0;
                reader.beginCompound();
                block15: while (reader.peek() != TagType.END) {
                    switch (reader.name()) {
                        case "x": {
                            x = reader.nextDouble();
                            continue block15;
                        }
                        case "y": {
                            y = reader.nextDouble();
                            continue block15;
                        }
                        case "z": {
                            z = reader.nextDouble();
                            continue block15;
                        }
                    }
                    reader.skip();
                }
                reader.endCompound();
                yield new Vector3d(x, y, z);
            }
            default -> throw new IllegalStateException("Unexpected tag-type: " + String.valueOf((Object)tag));
        };
    }
}

