/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.world.mca.data;

import com.flowpowered.math.vector.Vector3i;
import de.bluecolored.bluemap.core.resources.pack.datapack.DataPack;
import de.bluecolored.bluemap.core.util.Key;
import de.bluecolored.bluemap.core.world.DimensionType;
import de.bluecolored.bluenbt.NBTName;
import java.util.HashMap;
import java.util.Map;

public class LevelData {
    @NBTName(value={"Data"})
    private Data data = new Data();

    public Data getData() {
        return this.data;
    }

    public static class Data {
        @NBTName(value={"LevelName"})
        private String levelName = "world";
        private Spawn spawn = null;
        @NBTName(value={"WorldGenSettings"})
        private WGSettings worldGenSettings = new WGSettings();
        @NBTName(value={"SpawnX"})
        private int spawnX = 0;
        @NBTName(value={"SpawnY"})
        private int spawnY = 0;
        @NBTName(value={"SpawnZ"})
        private int spawnZ = 0;

        public Spawn getSpawn() {
            if (this.spawn == null) {
                this.spawn = new Spawn(new Vector3i(this.spawnX, this.spawnY, this.spawnZ));
            }
            return this.spawn;
        }

        public String getLevelName() {
            return this.levelName;
        }

        public WGSettings getWorldGenSettings() {
            return this.worldGenSettings;
        }
    }

    public static class Spawn {
        private Key dimension = DataPack.DIMENSION_OVERWORLD;
        private Vector3i position = Vector3i.ZERO;
        private float yaw = 0.0f;
        private float pitch = 0.0f;

        public Spawn(Vector3i position) {
            this.position = position;
        }

        public Key getDimension() {
            return this.dimension;
        }

        public Vector3i getPosition() {
            return this.position;
        }

        public float getYaw() {
            return this.yaw;
        }

        public float getPitch() {
            return this.pitch;
        }

        public Spawn() {
        }

        public Spawn(Key dimension, Vector3i position, float yaw, float pitch) {
            this.dimension = dimension;
            this.position = position;
            this.yaw = yaw;
            this.pitch = pitch;
        }
    }

    public static class Dimension {
        private DimensionType type = DimensionType.OVERWORLD;

        public DimensionType getType() {
            return this.type;
        }

        public Dimension() {
        }

        public Dimension(DimensionType type) {
            this.type = type;
        }
    }

    public static class WGSettings {
        private Map<String, Dimension> dimensions = new HashMap<String, Dimension>();

        public Map<String, Dimension> getDimensions() {
            return this.dimensions;
        }
    }
}

