/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.world.mca.data;

import de.bluecolored.bluemap.core.logger.Logger;
import de.bluecolored.bluemap.core.resources.pack.datapack.DataPack;
import de.bluecolored.bluemap.core.resources.pack.datapack.dimension.DimensionTypeData;
import de.bluecolored.bluemap.core.util.Key;
import de.bluecolored.bluemap.core.world.DimensionType;
import de.bluecolored.bluenbt.BlueNBT;
import de.bluecolored.bluenbt.NBTReader;
import de.bluecolored.bluenbt.TagType;
import de.bluecolored.bluenbt.TypeDeserializer;
import de.bluecolored.bluenbt.TypeToken;
import java.io.IOException;

public class DimensionTypeDeserializer
implements TypeDeserializer<DimensionType> {
    private final TypeDeserializer<DimensionTypeData> defaultTypeDeserializer;
    private final DataPack dataPack;

    public DimensionTypeDeserializer(BlueNBT blueNBT, DataPack dataPack) {
        this.defaultTypeDeserializer = blueNBT.getTypeDeserializer(TypeToken.of(DimensionTypeData.class));
        this.dataPack = dataPack;
    }

    @Override
    public DimensionType read(NBTReader reader) throws IOException {
        if (reader.peek() == TagType.COMPOUND) {
            return this.defaultTypeDeserializer.read(reader);
        }
        Key key = Key.parse(reader.nextString(), "minecraft");
        DimensionType dimensionType = this.dataPack.getDimensionType(key);
        if (dimensionType == null) {
            Logger.global.logWarning("No dimension-type found with the id '" + key.getFormatted() + "', using fallback.");
            dimensionType = DimensionType.OVERWORLD;
        }
        return dimensionType;
    }
}

