/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.util.math;

import com.flowpowered.math.TrigMath;
import de.bluecolored.bluemap.core.util.math.MatrixM3f;

public class MatrixM4f {
    public float m00 = 1.0f;
    public float m01;
    public float m02;
    public float m03;
    public float m10;
    public float m11 = 1.0f;
    public float m12;
    public float m13;
    public float m20;
    public float m21;
    public float m22 = 1.0f;
    public float m23;
    public float m30;
    public float m31;
    public float m32;
    public float m33 = 1.0f;

    public MatrixM4f set(float m00, float m01, float m02, float m03, float m10, float m11, float m12, float m13, float m20, float m21, float m22, float m23, float m30, float m31, float m32, float m33) {
        this.m00 = m00;
        this.m01 = m01;
        this.m02 = m02;
        this.m03 = m03;
        this.m10 = m10;
        this.m11 = m11;
        this.m12 = m12;
        this.m13 = m13;
        this.m20 = m20;
        this.m21 = m21;
        this.m22 = m22;
        this.m23 = m23;
        this.m30 = m30;
        this.m31 = m31;
        this.m32 = m32;
        this.m33 = m33;
        return this;
    }

    public MatrixM4f copy(MatrixM4f m4) {
        return this.set(m4.m00, m4.m01, m4.m02, m4.m03, m4.m10, m4.m11, m4.m12, m4.m13, m4.m20, m4.m21, m4.m22, m4.m23, m4.m30, m4.m31, m4.m32, m4.m33);
    }

    public MatrixM4f identity() {
        return this.set(1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public MatrixM4f translate(float x, float y, float z) {
        return this.multiplyTo(1.0f, 0.0f, 0.0f, x, 0.0f, 1.0f, 0.0f, y, 0.0f, 0.0f, 1.0f, z, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public MatrixM4f scale(float x, float y, float z) {
        return this.multiplyTo(x, 0.0f, 0.0f, 0.0f, 0.0f, y, 0.0f, 0.0f, 0.0f, 0.0f, z, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public MatrixM4f rotate(float angle, float axisX, float axisY, float axisZ) {
        double halfAngle = Math.toRadians(angle) * 0.5;
        double q = (double)TrigMath.sin((double)halfAngle) / Math.sqrt(axisX * axisX + axisY * axisY + axisZ * axisZ);
        double qx = (double)axisX * q;
        double qy = (double)axisY * q;
        double qz = (double)axisZ * q;
        double qw = TrigMath.cos((double)halfAngle);
        double qLength = Math.sqrt(qx * qx + qy * qy + qz * qz + qw * qw);
        return this.rotateByQuaternion((float)(qx /= qLength), (float)(qy /= qLength), (float)(qz /= qLength), (float)(qw /= qLength));
    }

    public MatrixM4f rotateXYZ(float pitch, float yaw, float roll) {
        double halfPitch = Math.toRadians(pitch) * 0.5;
        double sx = TrigMath.sin((double)halfPitch);
        double cx = TrigMath.cos((double)halfPitch);
        double halfYaw = Math.toRadians(yaw) * 0.5;
        double sy = TrigMath.sin((double)halfYaw);
        double cy = TrigMath.cos((double)halfYaw);
        double halfRoll = Math.toRadians(roll) * 0.5;
        double sz = TrigMath.sin((double)halfRoll);
        double cz = TrigMath.cos((double)halfRoll);
        double cycz = cy * cz;
        double sysz = sy * sz;
        double sycz = sy * cz;
        double cysz = cy * sz;
        return this.rotateByQuaternion((float)(sx * cycz + cx * sysz), (float)(cx * sycz - sx * cysz), (float)(cx * cysz + sx * sycz), (float)(cx * cycz - sx * sysz));
    }

    public MatrixM4f rotateZYX(float pitch, float yaw, float roll) {
        double halfPitch = Math.toRadians(pitch) * 0.5;
        double sx = TrigMath.sin((double)halfPitch);
        double cx = TrigMath.cos((double)halfPitch);
        double halfYaw = Math.toRadians(yaw) * 0.5;
        double sy = TrigMath.sin((double)halfYaw);
        double cy = TrigMath.cos((double)halfYaw);
        double halfRoll = Math.toRadians(roll) * 0.5;
        double sz = TrigMath.sin((double)halfRoll);
        double cz = TrigMath.cos((double)halfRoll);
        double cycz = cy * cz;
        double sysz = sy * sz;
        double sycz = sy * cz;
        double cysz = cy * sz;
        return this.rotateByQuaternion((float)(cx * cycz + sx * sysz), (float)(sx * cycz - cx * sysz), (float)(cx * sycz + sx * cysz), (float)(cx * cysz - sx * sycz));
    }

    public MatrixM4f rotateYXZ(float pitch, float yaw, float roll) {
        double halfPitch = Math.toRadians(pitch) * 0.5;
        double sx = TrigMath.sin((double)halfPitch);
        double cx = TrigMath.cos((double)halfPitch);
        double halfYaw = Math.toRadians(yaw) * 0.5;
        double sy = TrigMath.sin((double)halfYaw);
        double cy = TrigMath.cos((double)halfYaw);
        double halfRoll = Math.toRadians(roll) * 0.5;
        double sz = TrigMath.sin((double)halfRoll);
        double cz = TrigMath.cos((double)halfRoll);
        double cysx = cy * sx;
        double sycx = sy * cx;
        double sysx = sy * sx;
        double cycx = cy * cx;
        return this.rotateByQuaternion((float)(cysx * cz + sycx * sz), (float)(sycx * cz - cysx * sz), (float)(cycx * sz - sysx * cz), (float)(cycx * cz + sysx * sz));
    }

    public MatrixM4f rotateByQuaternion(float qx, float qy, float qz, float qw) {
        return this.multiplyTo(1.0f - 2.0f * qy * qy - 2.0f * qz * qz, 2.0f * qx * qy - 2.0f * qw * qz, 2.0f * qx * qz + 2.0f * qw * qy, 0.0f, 2.0f * qx * qy + 2.0f * qw * qz, 1.0f - 2.0f * qx * qx - 2.0f * qz * qz, 2.0f * qy * qz - 2.0f * qw * qx, 0.0f, 2.0f * qx * qz - 2.0f * qw * qy, 2.0f * qy * qz + 2.0f * qx * qw, 1.0f - 2.0f * qx * qx - 2.0f * qy * qy, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public MatrixM4f multiply(float m00, float m01, float m02, float m03, float m10, float m11, float m12, float m13, float m20, float m21, float m22, float m23, float m30, float m31, float m32, float m33) {
        return this.set(this.m00 * m00 + this.m01 * m10 + this.m02 * m20 + this.m03 * m30, this.m00 * m01 + this.m01 * m11 + this.m02 * m21 + this.m03 * m31, this.m00 * m02 + this.m01 * m12 + this.m02 * m22 + this.m03 * m32, this.m00 * m03 + this.m01 * m13 + this.m02 * m23 + this.m03 * m33, this.m10 * m00 + this.m11 * m10 + this.m12 * m20 + this.m13 * m30, this.m10 * m01 + this.m11 * m11 + this.m12 * m21 + this.m13 * m31, this.m10 * m02 + this.m11 * m12 + this.m12 * m22 + this.m13 * m32, this.m10 * m03 + this.m11 * m13 + this.m12 * m23 + this.m13 * m33, this.m20 * m00 + this.m21 * m10 + this.m22 * m20 + this.m23 * m30, this.m20 * m01 + this.m21 * m11 + this.m22 * m21 + this.m23 * m31, this.m20 * m02 + this.m21 * m12 + this.m22 * m22 + this.m23 * m32, this.m20 * m03 + this.m21 * m13 + this.m22 * m23 + this.m23 * m33, this.m30 * m00 + this.m31 * m10 + this.m32 * m20 + this.m33 * m30, this.m30 * m01 + this.m31 * m11 + this.m32 * m21 + this.m33 * m31, this.m30 * m02 + this.m31 * m12 + this.m32 * m22 + this.m33 * m32, this.m30 * m03 + this.m31 * m13 + this.m32 * m23 + this.m33 * m33);
    }

    public MatrixM4f multiplyTo(float m00, float m01, float m02, float m03, float m10, float m11, float m12, float m13, float m20, float m21, float m22, float m23, float m30, float m31, float m32, float m33) {
        return this.set(m00 * this.m00 + m01 * this.m10 + m02 * this.m20 + m03 * this.m30, m00 * this.m01 + m01 * this.m11 + m02 * this.m21 + m03 * this.m31, m00 * this.m02 + m01 * this.m12 + m02 * this.m22 + m03 * this.m32, m00 * this.m03 + m01 * this.m13 + m02 * this.m23 + m03 * this.m33, m10 * this.m00 + m11 * this.m10 + m12 * this.m20 + m13 * this.m30, m10 * this.m01 + m11 * this.m11 + m12 * this.m21 + m13 * this.m31, m10 * this.m02 + m11 * this.m12 + m12 * this.m22 + m13 * this.m32, m10 * this.m03 + m11 * this.m13 + m12 * this.m23 + m13 * this.m33, m20 * this.m00 + m21 * this.m10 + m22 * this.m20 + m23 * this.m30, m20 * this.m01 + m21 * this.m11 + m22 * this.m21 + m23 * this.m31, m20 * this.m02 + m21 * this.m12 + m22 * this.m22 + m23 * this.m32, m20 * this.m03 + m21 * this.m13 + m22 * this.m23 + m23 * this.m33, m30 * this.m00 + m31 * this.m10 + m32 * this.m20 + m33 * this.m30, m30 * this.m01 + m31 * this.m11 + m32 * this.m21 + m33 * this.m31, m30 * this.m02 + m31 * this.m12 + m32 * this.m22 + m33 * this.m32, m30 * this.m03 + m31 * this.m13 + m32 * this.m23 + m33 * this.m33);
    }

    public MatrixM4f multiplyTo(MatrixM3f m4) {
        return this.set(m4.m00 * this.m00 + m4.m01 * this.m10 + m4.m02 * this.m20, m4.m00 * this.m01 + m4.m01 * this.m11 + m4.m02 * this.m21, m4.m00 * this.m02 + m4.m01 * this.m12 + m4.m02 * this.m22, m4.m00 * this.m03 + m4.m01 * this.m13 + m4.m02 * this.m23, m4.m10 * this.m00 + m4.m11 * this.m10 + m4.m12 * this.m20, m4.m10 * this.m01 + m4.m11 * this.m11 + m4.m12 * this.m21, m4.m10 * this.m02 + m4.m11 * this.m12 + m4.m12 * this.m22, m4.m10 * this.m03 + m4.m11 * this.m13 + m4.m12 * this.m23, m4.m20 * this.m00 + m4.m21 * this.m10 + m4.m22 * this.m20, m4.m20 * this.m01 + m4.m21 * this.m11 + m4.m22 * this.m21, m4.m20 * this.m02 + m4.m21 * this.m12 + m4.m22 * this.m22, m4.m20 * this.m03 + m4.m21 * this.m13 + m4.m22 * this.m23, this.m30, this.m31, this.m32, this.m33);
    }
}

