/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.storage.file;

import de.bluecolored.bluemap.core.storage.Storage;
import de.bluecolored.bluemap.core.storage.compression.Compression;
import de.bluecolored.bluemap.core.storage.file.FileMapStorage;
import de.bluecolored.bluemap.core.util.Caches;
import de.bluecolored.shadow.caffeine.cache.LoadingCache;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.stream.Stream;

public class FileStorage
implements Storage {
    private final Path root;
    private final LoadingCache<String, FileMapStorage> mapStorages;

    public FileStorage(Path root, Compression compression, boolean atomic) {
        this.root = root;
        this.mapStorages = Caches.build(id -> new FileMapStorage(root.resolve((String)id), compression, atomic));
    }

    @Override
    public void initialize() throws IOException {
    }

    @Override
    public FileMapStorage map(String mapId) {
        return this.mapStorages.get(mapId);
    }

    @Override
    public Stream<String> mapIds() throws IOException {
        if (!Files.exists(this.root, new LinkOption[0])) {
            return Stream.empty();
        }
        return Files.list(this.root).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(Path::getFileName).map(Path::toString);
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public void close() throws IOException {
    }

    public Path getRoot() {
        return this.root;
    }
}

