/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.resources.pack.resourcepack.atlas;

import de.bluecolored.bluemap.core.logger.Logger;
import de.bluecolored.bluemap.core.resources.pack.ResourcePool;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.atlas.Source;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.texture.Texture;
import de.bluecolored.bluemap.core.util.Key;
import java.io.IOException;
import java.nio.file.Path;
import java.util.LinkedHashSet;
import java.util.function.Predicate;
import org.jetbrains.annotations.Contract;

public class Atlas {
    private LinkedHashSet<Source> sources = new LinkedHashSet();

    @Contract(value="_ -> this")
    public Atlas add(Atlas atlas) {
        this.sources.addAll(atlas.getSources());
        return this;
    }

    public void load(Path root, ResourcePool<Texture> textures, Predicate<Key> textureFilter) throws IOException {
        this.sources.forEach(source -> {
            try {
                source.load(root, textures, textureFilter);
            }
            catch (IOException e) {
                Logger.global.logDebug("Failed to load atlas-source: " + String.valueOf(e));
            }
        });
    }

    public void bake(ResourcePool<Texture> textures, Predicate<Key> textureFilter) throws IOException {
        this.sources.forEach(source -> {
            try {
                source.bake(textures, textureFilter);
            }
            catch (IOException e) {
                Logger.global.logDebug("Failed to bake atlas-source: " + String.valueOf(e));
            }
        });
    }

    public LinkedHashSet<Source> getSources() {
        return this.sources;
    }
}

