/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.logger;

import de.bluecolored.bluemap.core.logger.AbstractLogger;
import java.io.PrintStream;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import org.jetbrains.annotations.Nullable;

public class PrintStreamLogger
extends AbstractLogger {
    private final PrintStream out;
    private final PrintStream err;
    boolean isDebug;

    public PrintStreamLogger(PrintStream out, PrintStream err) {
        this.out = out;
        this.err = err;
        this.isDebug = false;
    }

    public PrintStreamLogger(PrintStream out, PrintStream err, boolean debug) {
        this.out = out;
        this.err = err;
        this.isDebug = debug;
    }

    public boolean isDebug() {
        return this.isDebug;
    }

    public void setDebug(boolean debug) {
        this.isDebug = debug;
    }

    @Override
    public void logError(String message, @Nullable Throwable throwable) {
        this.log(this.err, "ERROR", message);
        if (throwable != null) {
            throwable.printStackTrace(this.err);
        }
    }

    @Override
    public void logWarning(String message) {
        this.log(this.out, "WARNING", message);
    }

    @Override
    public void logInfo(String message) {
        this.log(this.out, "INFO", message);
    }

    @Override
    public void logDebug(String message) {
        if (this.isDebug) {
            this.log(this.out, "DEBUG", message);
        }
    }

    @Override
    public void noFloodDebug(String key, String message) {
        if (this.isDebug) {
            super.noFloodDebug(key, message);
        }
    }

    @Override
    public void noFloodDebug(String message) {
        if (this.isDebug) {
            super.noFloodDebug(message);
        }
    }

    private void log(PrintStream stream, String level, String message) {
        ZonedDateTime zdt = ZonedDateTime.ofInstant(Instant.now(), ZoneId.systemDefault());
        stream.printf("[%1$tT %2$s] %3$s%n", zdt, level, message);
    }
}

