/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.rendermanager;

import de.bluecolored.bluemap.common.rendermanager.RenderTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class CombinedRenderTask<T extends RenderTask>
implements RenderTask {
    private final String description;
    private final List<T> tasks;
    private int currentTaskIndex;

    public CombinedRenderTask(String description, Collection<T> tasks) {
        this.description = description;
        this.tasks = Collections.unmodifiableList(new ArrayList<T>(tasks));
        this.currentTaskIndex = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doWork() throws Exception {
        RenderTask task;
        CombinedRenderTask combinedRenderTask = this;
        synchronized (combinedRenderTask) {
            if (!this.hasMoreWork()) {
                return;
            }
            task = (RenderTask)this.tasks.get(this.currentTaskIndex);
            if (!task.hasMoreWork()) {
                ++this.currentTaskIndex;
                return;
            }
        }
        task.doWork();
    }

    @Override
    public synchronized boolean hasMoreWork() {
        return this.currentTaskIndex < this.tasks.size();
    }

    @Override
    public double estimateProgress() {
        int currentTask = this.currentTaskIndex;
        if (currentTask >= this.tasks.size()) {
            return 1.0;
        }
        double total = currentTask;
        return (total += ((RenderTask)this.tasks.get(currentTask)).estimateProgress()) / (double)this.tasks.size();
    }

    @Override
    public void cancel() {
        for (RenderTask task : this.tasks) {
            task.cancel();
        }
    }

    @Override
    public boolean contains(RenderTask task) {
        if (this.equals(task)) {
            return true;
        }
        if (task instanceof CombinedRenderTask) {
            CombinedRenderTask combinedTask = (CombinedRenderTask)task;
            for (RenderTask subTask : combinedTask.tasks) {
                if (this.contains(subTask)) continue;
                return false;
            }
            return true;
        }
        for (RenderTask subTask : this.tasks) {
            if (!subTask.contains(task)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Optional<String> getDetail() {
        if (this.currentTaskIndex >= this.tasks.size()) {
            return Optional.empty();
        }
        return Optional.ofNullable(((RenderTask)this.tasks.get(this.currentTaskIndex)).getDescription());
    }
}

