/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.metrics;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import de.bluecolored.bluemap.core.BlueMap;
import de.bluecolored.bluemap.core.logger.Logger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import javax.net.ssl.HttpsURLConnection;

public class Metrics {
    private static final String METRICS_REPORT_URL = "https://metrics.bluecolored.de/bluemap/";
    private static final Gson GSON = new GsonBuilder().create();

    public static void sendReportAsync(String implementation, String mcVersion) {
        new Thread(() -> Metrics.sendReport(implementation, mcVersion), "BlueMap-Plugin-SendMetricsReport").start();
    }

    public static void sendReport(String implementation, String mcVersion) {
        Report report = new Report(implementation, BlueMap.VERSION, mcVersion);
        try {
            Metrics.sendData(GSON.toJson((Object)report));
        }
        catch (IOException | RuntimeException ex) {
            Logger.global.logDebug("Failed to send Metrics-Report: " + String.valueOf(ex));
        }
    }

    private static String sendData(String data) throws IOException {
        byte[] bytes = data.getBytes(StandardCharsets.UTF_8);
        HttpsURLConnection connection = (HttpsURLConnection)URI.create(METRICS_REPORT_URL).toURL().openConnection();
        connection.setRequestMethod("POST");
        connection.addRequestProperty("Content-Length", String.valueOf(bytes.length));
        connection.setRequestProperty("Content-Type", "application/json");
        connection.addRequestProperty("Content-Encoding", "gzip");
        connection.addRequestProperty("Connection", "close");
        connection.setRequestProperty("User-Agent", "BlueMap");
        connection.setDoOutput(true);
        try (OutputStream out = connection.getOutputStream();){
            out.write(bytes);
            out.flush();
        }
        try (BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));){
            String line;
            StringBuilder builder = new StringBuilder();
            while ((line = in.readLine()) != null) {
                builder.append(line).append("\n");
            }
            String string = builder.toString();
            return string;
        }
    }

    record Report(String implementation, String version, String mcVersion) {
    }
}

