/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.commands.checks;

import com.flowpowered.math.vector.Vector2i;
import de.bluecolored.bluemap.common.commands.TextFormat;
import de.bluecolored.bluemap.common.commands.checks.Check;
import de.bluecolored.bluemap.common.commands.checks.CheckResult;
import de.bluecolored.bluemap.common.plugin.Plugin;
import de.bluecolored.bluemap.common.rendermanager.RenderTask;
import de.bluecolored.bluemap.common.rendermanager.WorldRegionRenderTask;
import de.bluecolored.bluemap.core.map.BmMap;
import net.kyori.adventure.text.Component;

public class TileIsUpdatedCheck
implements Check {
    private final Plugin plugin;
    private final BmMap map;
    private final Vector2i position;
    private final Vector2i region;

    public TileIsUpdatedCheck(Plugin plugin, BmMap map, Vector2i position) {
        this.plugin = plugin;
        this.map = map;
        this.position = position;
        this.region = map.getWorld().getRegionGrid().getCell(position);
    }

    @Override
    public CheckResult getResult() {
        WorldRegionRenderTask regionRenderTask = new WorldRegionRenderTask(this.map, this.region);
        RenderTask current = this.plugin.getRenderManager().getCurrentRenderTask();
        if (current == null) {
            return CheckResult.OK;
        }
        return !current.contains(regionRenderTask) && !this.plugin.getRenderManager().containsRenderTask(regionRenderTask) ? CheckResult.OK : CheckResult.BAD;
    }

    @Override
    public Component getFailureDescription() {
        return TextFormat.lines(new Component[]{TextFormat.format("\u26a0 the region around (x:%, z:%) has pending\nupdates for map %\n".strip(), this.position.getX(), this.position.getY(), TextFormat.formatMap(this.map).color(TextFormat.HIGHLIGHT_COLOR)), Component.empty(), TextFormat.format("wait until the map finished updating\nyou can use % to see the update progress\n".strip(), TextFormat.command("/bluemap").color(TextFormat.HIGHLIGHT_COLOR)).color(TextFormat.BASE_COLOR)});
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public BmMap getMap() {
        return this.map;
    }

    public Vector2i getPosition() {
        return this.position;
    }

    public Vector2i getRegion() {
        return this.region;
    }

    public TileIsUpdatedCheck(Plugin plugin, BmMap map, Vector2i position, Vector2i region) {
        this.plugin = plugin;
        this.map = map;
        this.position = position;
        this.region = region;
    }
}

