/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.commands.checks;

import de.bluecolored.bluemap.common.commands.TextFormat;
import de.bluecolored.bluemap.common.commands.checks.Check;
import de.bluecolored.bluemap.common.commands.checks.CheckResult;
import de.bluecolored.bluemap.common.plugin.Plugin;
import de.bluecolored.bluemap.core.map.BmMap;
import net.kyori.adventure.text.Component;

public class MapIsNotFrozenCheck
implements Check {
    private final Plugin plugin;
    private final BmMap map;

    @Override
    public CheckResult getResult() {
        return this.plugin.getPluginState().getMapState(this.map).isUpdateEnabled() ? CheckResult.OK : CheckResult.BAD;
    }

    @Override
    public Component getFailureDescription() {
        return TextFormat.format(TextFormat.lines(new Component[]{Component.text((String)"\u26a0 map % is frozen"), Component.text((String)"a frozen map will not be updated"), Component.empty(), Component.text((String)"you can use % to unfreeze the map").color(TextFormat.BASE_COLOR)}), TextFormat.formatMap(this.map).color(TextFormat.HIGHLIGHT_COLOR), TextFormat.command("/bluemap unfreeze " + this.map.getId()).color(TextFormat.HIGHLIGHT_COLOR));
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public BmMap getMap() {
        return this.map;
    }

    public MapIsNotFrozenCheck(Plugin plugin, BmMap map) {
        this.plugin = plugin;
        this.map = map;
    }
}

