/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.api;

import de.bluecolored.bluemap.api.BlueMapAPI;
import de.bluecolored.bluemap.api.BlueMapMap;
import de.bluecolored.bluemap.api.BlueMapWorld;
import de.bluecolored.bluemap.common.BlueMapService;
import de.bluecolored.bluemap.common.api.BlueMapMapImpl;
import de.bluecolored.bluemap.common.api.BlueMapWorldImpl;
import de.bluecolored.bluemap.common.api.PluginImpl;
import de.bluecolored.bluemap.common.api.RenderManagerImpl;
import de.bluecolored.bluemap.common.api.WebAppImpl;
import de.bluecolored.bluemap.common.plugin.Plugin;
import de.bluecolored.bluemap.common.serverinterface.ServerWorld;
import de.bluecolored.bluemap.core.BlueMap;
import de.bluecolored.bluemap.core.logger.Logger;
import de.bluecolored.bluemap.core.map.BmMap;
import de.bluecolored.bluemap.core.util.Caches;
import de.bluecolored.bluemap.core.world.World;
import de.bluecolored.shadow.caffeine.cache.LoadingCache;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

public class BlueMapAPIImpl
extends BlueMapAPI {
    private final BlueMapService blueMapService;
    @Nullable
    private final Plugin plugin;
    private final WebAppImpl webAppImpl;
    @Nullable
    private final RenderManagerImpl renderManagerImpl;
    @Nullable
    private final PluginImpl pluginImpl;
    private final LoadingCache<Object, Optional<BlueMapWorld>> worldCache;
    private final LoadingCache<String, Optional<BlueMapMap>> mapCache;

    public BlueMapAPIImpl(Plugin plugin) {
        this(plugin.getBlueMap(), plugin);
    }

    public BlueMapAPIImpl(BlueMapService blueMapService, @Nullable Plugin plugin) {
        this.blueMapService = blueMapService;
        this.plugin = plugin;
        this.renderManagerImpl = plugin != null ? new RenderManagerImpl(this, plugin) : null;
        this.webAppImpl = new WebAppImpl(blueMapService, plugin);
        this.pluginImpl = plugin != null ? new PluginImpl(plugin) : null;
        this.worldCache = Caches.with().weakKeys().build(this::getWorldUncached);
        this.mapCache = Caches.with().weakKeys().build(this::getMapUncached);
    }

    @Override
    public Collection<BlueMapMap> getMaps() {
        Map<String, BmMap> maps = this.blueMapService.getMaps();
        return maps.keySet().stream().map(this::getMap).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public Collection<BlueMapWorld> getWorlds() {
        Map<String, World> worlds = this.blueMapService.getWorlds();
        return worlds.keySet().stream().map(this::getWorld).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public Optional<BlueMapWorld> getWorld(@NonNull Object world) {
        if (world == null) {
            throw new NullPointerException("world is marked non-null but is null");
        }
        return this.worldCache.get(world);
    }

    public Optional<BlueMapWorld> getWorldUncached(Object world) {
        World coreWorld;
        if (world instanceof String && (coreWorld = this.blueMapService.getWorlds().get(world)) != null) {
            world = coreWorld;
        }
        if (world instanceof World) {
            coreWorld = (World)world;
            return Optional.of(new BlueMapWorldImpl(coreWorld, this.blueMapService, this.plugin));
        }
        if (this.plugin == null) {
            return Optional.empty();
        }
        ServerWorld serverWorld = this.plugin.getServerInterface().getServerWorld(world).orElse(null);
        if (serverWorld == null) {
            return Optional.empty();
        }
        World coreWorld2 = this.plugin.getWorld(serverWorld);
        if (coreWorld2 == null) {
            return Optional.empty();
        }
        return Optional.of(new BlueMapWorldImpl(coreWorld2, this.blueMapService, this.plugin));
    }

    @Override
    public Optional<BlueMapMap> getMap(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        return this.mapCache.get(id);
    }

    public Optional<BlueMapMap> getMapUncached(String id) {
        Map<String, BmMap> maps = this.blueMapService.getMaps();
        BmMap map = maps.get(id);
        if (map == null) {
            return Optional.empty();
        }
        BlueMapWorld world = this.getWorld(map.getWorld()).orElse(null);
        if (world == null) {
            return Optional.empty();
        }
        return Optional.of(new BlueMapMapImpl(map, (BlueMapWorldImpl)world, this.plugin));
    }

    @Override
    public String getBlueMapVersion() {
        return BlueMap.VERSION;
    }

    @Override
    public WebAppImpl getWebApp() {
        return this.webAppImpl;
    }

    @Override
    public RenderManagerImpl getRenderManager() {
        if (this.renderManagerImpl == null) {
            throw new UnsupportedOperationException("RenderManager API is not supported on this platform");
        }
        return this.renderManagerImpl;
    }

    @Override
    public de.bluecolored.bluemap.api.plugin.Plugin getPlugin() {
        if (this.pluginImpl == null) {
            throw new UnsupportedOperationException("Plugin API is not supported on this platform");
        }
        return this.pluginImpl;
    }

    public void register() {
        try {
            BlueMapAPI.registerInstance(this);
        }
        catch (Exception ex) {
            Logger.global.logError("BlueMapAPI: A BlueMapAPI listener threw an exception (onEnable)!", ex);
        }
    }

    public void unregister() {
        try {
            BlueMapAPI.unregisterInstance(this);
        }
        catch (Exception ex) {
            Logger.global.logError("BlueMapAPI: A BlueMapAPI listener threw an exception (onDisable)!", ex);
        }
    }

    public BlueMapService blueMapService() {
        return this.blueMapService;
    }

    @Nullable
    public Plugin plugin() {
        return this.plugin;
    }
}

