/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.bukkit;

import com.destroystokyo.paper.event.player.PlayerPostRespawnEvent;
import com.mojang.brigadier.tree.LiteralCommandNode;
import de.bluecolored.bluecommands.brigadier.BrigadierBridge;
import de.bluecolored.bluemap.bukkit.BukkitCommandSource;
import de.bluecolored.bluemap.bukkit.BukkitPlayer;
import de.bluecolored.bluemap.bukkit.BukkitWorld;
import de.bluecolored.bluemap.bukkit.EventForwarder;
import de.bluecolored.bluemap.bukkit.FoliaSupport;
import de.bluecolored.bluemap.common.commands.BrigadierExecutionHandler;
import de.bluecolored.bluemap.common.plugin.Plugin;
import de.bluecolored.bluemap.common.serverinterface.Player;
import de.bluecolored.bluemap.common.serverinterface.Server;
import de.bluecolored.bluemap.common.serverinterface.ServerEventListener;
import de.bluecolored.bluemap.common.serverinterface.ServerWorld;
import de.bluecolored.bluemap.core.logger.JavaLogger;
import de.bluecolored.bluemap.core.logger.Logger;
import de.bluecolored.bluemap.core.util.Caches;
import de.bluecolored.bluemap.core.util.Key;
import de.bluecolored.shadow.bstats.bukkit.Metrics;
import de.bluecolored.shadow.caffeine.cache.LoadingCache;
import io.papermc.paper.ServerBuildInfo;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEventType;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.java.JavaPlugin;

public class BukkitPlugin
extends JavaPlugin
implements Server,
Listener {
    private static BukkitPlugin instance;
    private final Plugin pluginInstance;
    private final EventForwarder eventForwarder;
    private final Map<UUID, Player> onlinePlayerMap;
    private final List<BukkitPlayer> onlinePlayerList;
    private final Collection<ScheduledTask> scheduledTasks;
    private final LoadingCache<World, ServerWorld> worlds;

    public BukkitPlugin() {
        Logger.global.clear();
        Logger.global.put(new JavaLogger(this.getLogger()));
        this.onlinePlayerMap = new ConcurrentHashMap<UUID, Player>();
        this.onlinePlayerList = Collections.synchronizedList(new ArrayList());
        this.scheduledTasks = Collections.synchronizedCollection(Collections.newSetFromMap(new WeakHashMap()));
        this.eventForwarder = new EventForwarder();
        this.pluginInstance = new Plugin("paper", this);
        this.worlds = Caches.with().weakKeys().maximumSize(1000L).build(BukkitWorld::new);
        instance = this;
    }

    public void onEnable() {
        if (!FoliaSupport.IS_FOLIA) {
            Logger.global.logInfo("Saving all worlds once, to make sure the level.dat is present...");
            for (World world : this.getServer().getWorlds()) {
                world.save();
            }
        }
        this.getServer().getPluginManager().registerEvents((Listener)this, (org.bukkit.plugin.Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)this.eventForwarder, (org.bukkit.plugin.Plugin)this);
        this.getLifecycleManager().registerEventHandler((LifecycleEventType)LifecycleEvents.COMMANDS, commands -> BrigadierBridge.createCommandNodes(de.bluecolored.bluemap.common.commands.Commands.create(this.pluginInstance), new BrigadierExecutionHandler(this.pluginInstance), BukkitCommandSource::new).forEach(command -> {
            if (command instanceof LiteralCommandNode) {
                LiteralCommandNode literal = (LiteralCommandNode)command;
                ((Commands)commands.registrar()).register(literal);
            }
        }));
        this.onlinePlayerList.clear();
        this.onlinePlayerMap.clear();
        for (org.bukkit.entity.Player player : this.getServer().getOnlinePlayers()) {
            this.initPlayer(player);
        }
        new Thread(() -> {
            try {
                Logger.global.logInfo("Loading...");
                this.pluginInstance.load();
                if (this.pluginInstance.isLoaded()) {
                    Logger.global.logInfo("Loaded!");
                }
            }
            catch (IOException | RuntimeException e) {
                Logger.global.logError("Failed to load!", e);
                this.pluginInstance.unload();
            }
        }, "BlueMap-Load").start();
        new Metrics(this, 5912);
    }

    public void onDisable() {
        Logger.global.logInfo("Stopping...");
        this.scheduledTasks.forEach(task -> {
            if (task != null) {
                task.cancel();
            }
        });
        this.scheduledTasks.clear();
        this.pluginInstance.unload();
        Logger.global.logInfo("Saved and stopped!");
    }

    @Override
    public String getMinecraftVersion() {
        return ServerBuildInfo.buildInfo().minecraftVersionId();
    }

    @Override
    public void registerListener(ServerEventListener listener) {
        this.eventForwarder.addListener(listener);
    }

    @Override
    public void unregisterAllListeners() {
        this.eventForwarder.removeAllListeners();
    }

    @Override
    public Collection<ServerWorld> getLoadedServerWorlds() {
        ArrayList<ServerWorld> loadedWorlds = new ArrayList<ServerWorld>(3);
        for (World world : Bukkit.getWorlds()) {
            loadedWorlds.add(this.worlds.get(world));
        }
        return loadedWorlds;
    }

    @Override
    public Optional<ServerWorld> getServerWorld(Object world) {
        World serverWorld;
        if (world instanceof String && (serverWorld = Bukkit.getWorld((String)((String)world))) != null) {
            world = serverWorld;
        }
        if (world instanceof String && (serverWorld = Bukkit.getWorld((String)new Key((String)world).getValue())) != null) {
            world = serverWorld;
        }
        if (world instanceof UUID && (serverWorld = Bukkit.getWorld((UUID)((UUID)world))) != null) {
            world = serverWorld;
        }
        if (world instanceof World) {
            return Optional.of(this.getServerWorld((World)world));
        }
        return Optional.empty();
    }

    public ServerWorld getServerWorld(World world) {
        return this.worlds.get(Objects.requireNonNull(world));
    }

    @Override
    public Path getConfigFolder() {
        return this.getDataFolder().toPath();
    }

    @Override
    public Optional<Path> getModsFolder() {
        return Optional.of(Path.of("mods", new String[0]));
    }

    public Plugin getPlugin() {
        return this.pluginInstance;
    }

    public static BukkitPlugin getInstance() {
        return instance;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerJoin(PlayerJoinEvent evt) {
        this.initPlayer(evt.getPlayer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerLeave(PlayerQuitEvent evt) {
        UUID playerUUID = evt.getPlayer().getUniqueId();
        this.onlinePlayerMap.remove(playerUUID);
        List<BukkitPlayer> list = this.onlinePlayerList;
        synchronized (list) {
            this.onlinePlayerList.removeIf(p -> p.getUuid().equals(playerUUID));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerRespawn(PlayerPostRespawnEvent evt) {
        this.initPlayer(evt.getPlayer());
    }

    @Override
    public Collection<Player> getOnlinePlayers() {
        return this.onlinePlayerMap.values();
    }

    private void initPlayer(org.bukkit.entity.Player bukkitPlayer) {
        BukkitPlayer player = new BukkitPlayer(bukkitPlayer);
        this.onlinePlayerMap.put(bukkitPlayer.getUniqueId(), player);
        this.onlinePlayerList.add(player);
        this.scheduledTasks.add(bukkitPlayer.getScheduler().runAtFixedRate((org.bukkit.plugin.Plugin)this, task -> player.update(), null, 20L, 20L));
    }
}

