/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluecommands.brigadier;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.bluecolored.bluecommands.Command;
import de.bluecolored.bluecommands.InputReader;
import de.bluecolored.bluecommands.ParseFailure;
import de.bluecolored.bluecommands.ParseResult;
import de.bluecolored.bluecommands.Suggestion;
import de.bluecolored.bluecommands.brigadier.TooltipSuggestion;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

class CommandSuggestionProvider<D>
implements SuggestionProvider<D> {
    private final ParseFunction<D> command = (context, input) -> command.parse(conversion.apply(context), input);

    public <C> CommandSuggestionProvider(Command<C, ?> command, Function<D, C> conversion) {
    }

    public CompletableFuture<Suggestions> getSuggestions(CommandContext<D> context, SuggestionsBuilder suggestionsBuilder) {
        return CompletableFuture.supplyAsync(() -> {
            InputReader inputReader = new InputReader(context.getInput());
            inputReader.setPosition(context.getRange().getStart());
            ParseResult<?, ?> result = this.command.parse(context.getSource(), inputReader);
            int start = suggestionsBuilder.getInput().lastIndexOf(32) + 1;
            SuggestionsBuilder builder = suggestionsBuilder.createOffset(start);
            HashMap<String, Suggestion> suggestionMap = new HashMap<String, Suggestion>();
            for (ParseFailure<?, ?> failure : result.getFailures()) {
                if (failure.getPosition() != builder.getStart()) continue;
                for (Suggestion suggestion : failure.getSuggestions()) {
                    suggestionMap.put(suggestion.getString(), suggestion);
                }
            }
            for (Suggestion suggestion : suggestionMap.values()) {
                if (suggestion instanceof TooltipSuggestion) {
                    builder.suggest(suggestion.getString(), ((TooltipSuggestion)suggestion).getTooltip());
                    continue;
                }
                builder.suggest(suggestion.getString());
            }
            return builder.build();
        });
    }

    static interface ParseFunction<C> {
        public ParseResult<?, ?> parse(C var1, InputReader var2);
    }
}

