/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.resources.pack.resourcepack.entitystate;

import com.flowpowered.math.vector.Vector3f;
import de.bluecolored.bluemap.core.map.hires.entity.EntityRendererType;
import de.bluecolored.bluemap.core.resources.ResourcePath;
import de.bluecolored.bluemap.core.resources.adapter.PostDeserialize;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.ResourcePack;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.model.Model;
import de.bluecolored.bluemap.core.util.math.MatrixM4f;

public class Part {
    private EntityRendererType renderer = EntityRendererType.DEFAULT;
    private ResourcePath<Model> model = ResourcePack.MISSING_ENTITY_MODEL;
    private Vector3f position = Vector3f.ZERO;
    private Vector3f rotation = Vector3f.ZERO;
    private transient boolean transformed;
    private transient MatrixM4f transformMatrix;

    public Part(ResourcePath<Model> model) {
        this.model = model;
        this.init();
    }

    public Part(ResourcePath<Model> model, Vector3f position, Vector3f rotation) {
        this.model = model;
        this.position = position;
        this.rotation = rotation;
        this.init();
    }

    @PostDeserialize
    private void init() {
        this.transformed = !this.position.equals((Object)Vector3f.ZERO) || !this.rotation.equals((Object)Vector3f.ZERO);
        this.transformMatrix = new MatrixM4f().rotate(this.rotation.getX(), this.rotation.getY(), this.rotation.getZ()).translate(this.position.getX(), this.position.getY(), this.position.getZ());
    }

    private Part() {
    }

    public EntityRendererType getRenderer() {
        return this.renderer;
    }

    public ResourcePath<Model> getModel() {
        return this.model;
    }

    public Vector3f getPosition() {
        return this.position;
    }

    public Vector3f getRotation() {
        return this.rotation;
    }

    public boolean isTransformed() {
        return this.transformed;
    }

    public MatrixM4f getTransformMatrix() {
        return this.transformMatrix;
    }

    public void setRenderer(EntityRendererType renderer) {
        this.renderer = renderer;
    }
}

