/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.resources.pack.resourcepack;

import de.bluecolored.bluemap.core.BlueMap;
import de.bluecolored.bluemap.core.logger.Logger;
import de.bluecolored.bluemap.core.resources.BlockColorCalculatorFactory;
import de.bluecolored.bluemap.core.resources.BlockPropertiesConfig;
import de.bluecolored.bluemap.core.resources.ResourcePath;
import de.bluecolored.bluemap.core.resources.adapter.ResourcesGson;
import de.bluecolored.bluemap.core.resources.pack.Pack;
import de.bluecolored.bluemap.core.resources.pack.PackVersion;
import de.bluecolored.bluemap.core.resources.pack.ResourcePool;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.ResourcePackExtension;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.atlas.Atlas;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.blockstate.BlockState;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.entitystate.EntityState;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.model.Model;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.model.TextureVariable;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.texture.Texture;
import de.bluecolored.bluemap.core.util.Key;
import de.bluecolored.bluemap.core.util.Keyed;
import de.bluecolored.bluemap.core.util.Registry;
import de.bluecolored.bluemap.core.util.Tristate;
import de.bluecolored.bluemap.core.world.BlockProperties;
import de.bluecolored.shadow.caffeine.cache.Caffeine;
import de.bluecolored.shadow.caffeine.cache.LoadingCache;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import javax.imageio.ImageIO;

public class ResourcePack
extends Pack {
    public static final ResourcePath<BlockState> MISSING_BLOCK_STATE = new ResourcePath("bluemap", "missing");
    public static final ResourcePath<EntityState> MISSING_ENTITY_STATE = new ResourcePath("bluemap", "missing");
    public static final ResourcePath<Model> MISSING_BLOCK_MODEL = new ResourcePath("bluemap", "block/missing");
    public static final ResourcePath<Model> MISSING_ENTITY_MODEL = new ResourcePath("bluemap", "entity/missing");
    public static final ResourcePath<Texture> MISSING_TEXTURE = new ResourcePath("bluemap", "block/missing");
    private static final Key BLOCKS_ATLAS = Key.minecraft("blocks");
    private final ResourcePool<Atlas> atlases = new ResourcePool();
    private final ResourcePool<BlockState> blockStates = new ResourcePool();
    private final ResourcePool<EntityState> entityStates = new ResourcePool();
    private final ResourcePool<Model> models = new ResourcePool();
    private final ResourcePool<Texture> textures = new ResourcePool();
    private final ResourcePool<BufferedImage> colormaps = new ResourcePool();
    private final BlockColorCalculatorFactory colorCalculatorFactory = new BlockColorCalculatorFactory();
    private final BlockPropertiesConfig blockPropertiesConfig = new BlockPropertiesConfig();
    private final LoadingCache<de.bluecolored.bluemap.core.world.BlockState, BlockProperties> blockPropertiesCache = Caffeine.newBuilder().executor(BlueMap.THREAD_POOL).maximumSize(10000L).expireAfterAccess(1L, TimeUnit.MINUTES).build(this::loadBlockProperties);
    private final Map<Extension<?>, ResourcePackExtension> extensions = new HashMap();

    public ResourcePack(PackVersion packVersion) {
        super(packVersion);
        for (Extension<?> extensionType : Extension.REGISTRY.values()) {
            this.extensions.put(extensionType, (ResourcePackExtension)extensionType.create(this));
        }
    }

    @Override
    public synchronized void loadResources(Iterable<Path> roots) throws IOException, InterruptedException {
        Logger.global.logInfo("Loading resources...");
        for (Path path2 : roots) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            Logger.global.logDebug("Loading resources from: " + String.valueOf(path2) + " ...");
            this.loadResourcePath(path2, this::loadResources);
        }
        for (Map.Entry entry : this.extensions.entrySet()) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            Logger.global.logDebug("Loading extension: " + String.valueOf(((Extension)entry.getKey()).getKey()));
            ((ResourcePackExtension)entry.getValue()).loadResources(roots);
        }
        Logger.global.logDebug("Collecting texture-keys...");
        Set<Key> usedTextureKeys = this.collectUsedTextureKeys();
        Logger.global.logDebug("Found " + usedTextureKeys.size() + " texture-keys.");
        for (Path path3 : roots) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            Logger.global.logDebug("Loading textures from: " + String.valueOf(path3) + " ...");
            this.loadResourcePath(path3, path -> this.getBlocksAtlas().load(path, this.textures, usedTextureKeys::contains));
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Logger.global.logDebug("Baking resources...");
        this.bake(usedTextureKeys::contains);
        for (Map.Entry<Extension<?>, ResourcePackExtension> entry : this.extensions.entrySet()) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            Logger.global.logDebug("Baking extension: " + String.valueOf(entry.getKey().getKey()));
            entry.getValue().bake();
        }
        Logger.global.logInfo("Resources loaded.");
    }

    private void loadResources(Path root) throws IOException {
        try {
            CompletableFuture.allOf(CompletableFuture.runAsync(() -> ResourcePack.list(root.resolve("assets")).map(path -> path.resolve("atlases")).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).flatMap(Pack::walk).filter(path -> path.getFileName().toString().endsWith(".json")).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(file -> this.atlases.load(new ResourcePath(root.relativize((Path)file), 1, 3), key -> {
                try (BufferedReader reader = Files.newBufferedReader(file);){
                    Atlas atlas = (Atlas)ResourcesGson.INSTANCE.fromJson((Reader)reader, Atlas.class);
                    return atlas;
                }
            }, Atlas::add)), BlueMap.THREAD_POOL), CompletableFuture.runAsync(() -> ResourcePack.list(root.resolve("assets")).map(path -> path.resolve("blockstates")).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).flatMap(Pack::walk).filter(path -> path.getFileName().toString().endsWith(".json")).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(file -> this.blockStates.load(new ResourcePath(root.relativize((Path)file), 1, 3), key -> {
                try (BufferedReader reader = Files.newBufferedReader(file);){
                    BlockState blockState = (BlockState)ResourcesGson.INSTANCE.fromJson((Reader)reader, BlockState.class);
                    return blockState;
                }
            })), BlueMap.THREAD_POOL), CompletableFuture.runAsync(() -> ResourcePack.list(root.resolve("assets")).map(path -> path.resolve("entitystates")).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).flatMap(Pack::walk).filter(path -> path.getFileName().toString().endsWith(".json")).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(file -> this.entityStates.load(new ResourcePath(root.relativize((Path)file), 1, 3), key -> {
                try (BufferedReader reader = Files.newBufferedReader(file);){
                    EntityState entityState = (EntityState)ResourcesGson.INSTANCE.fromJson((Reader)reader, EntityState.class);
                    return entityState;
                }
            })), BlueMap.THREAD_POOL), CompletableFuture.runAsync(() -> ResourcePack.list(root.resolve("assets")).map(path -> path.resolve("models")).flatMap(Pack::list).filter(path -> !path.getFileName().toString().equals("item")).flatMap(Pack::walk).filter(path -> path.getFileName().toString().endsWith(".json")).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(file -> this.models.load(new ResourcePath(root.relativize((Path)file), 1, 3), key -> {
                try (BufferedReader reader = Files.newBufferedReader(file);){
                    Model model = (Model)ResourcesGson.INSTANCE.fromJson((Reader)reader, Model.class);
                    return model;
                }
            })), BlueMap.THREAD_POOL), CompletableFuture.runAsync(() -> ResourcePack.walk(root.resolve("assets").resolve("minecraft").resolve("textures").resolve("colormap")).filter(path -> path.getFileName().toString().endsWith(".png")).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(file -> this.colormaps.load(new ResourcePath(root.relativize((Path)file), 1, 3), key -> {
                try (InputStream in = Files.newInputStream(file, new OpenOption[0]);){
                    BufferedImage bufferedImage = ImageIO.read(in);
                    return bufferedImage;
                }
            })), BlueMap.THREAD_POOL), CompletableFuture.runAsync(() -> ResourcePack.list(root.resolve("assets")).map(path -> path.resolve("blockColors.json")).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(file -> {
                try {
                    this.colorCalculatorFactory.load((Path)file);
                }
                catch (Exception ex) {
                    Logger.global.logDebug("Failed to parse resource-file '" + String.valueOf(file) + "': " + String.valueOf(ex));
                }
            }), BlueMap.THREAD_POOL), CompletableFuture.runAsync(() -> ResourcePack.list(root.resolve("assets")).map(path -> path.resolve("blockProperties.json")).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(file -> {
                try {
                    this.blockPropertiesConfig.load((Path)file);
                }
                catch (Exception ex) {
                    Logger.global.logDebug("Failed to parse resource-file '" + String.valueOf(file) + "': " + String.valueOf(ex));
                }
            }), BlueMap.THREAD_POOL)).join();
        }
        catch (RuntimeException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause != null) {
                throw new IOException(cause);
            }
            throw new IOException(ex);
        }
    }

    private void bake(Predicate<Key> textureFilter) throws IOException, InterruptedException {
        BufferedImage grass;
        BufferedImage dryFoliage;
        this.getBlocksAtlas().bake(this.textures, textureFilter);
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        for (Model model : this.models.values()) {
            model.optimize(this.textures);
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        for (Model model : this.models.values()) {
            model.applyParent(this.models);
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        for (Model model : this.models.values()) {
            model.calculateProperties(this.textures);
        }
        BufferedImage foliage = new ResourcePath<BufferedImage>("minecraft:colormap/foliage").getResource(this.colormaps::get);
        if (foliage != null) {
            this.colorCalculatorFactory.setFoliageMap(foliage);
        }
        if ((dryFoliage = new ResourcePath<BufferedImage>("minecraft:colormap/dry_foliage").getResource(this.colormaps::get)) != null) {
            this.colorCalculatorFactory.setDryFoliageMap(dryFoliage);
        }
        if ((grass = new ResourcePath<BufferedImage>("minecraft:colormap/grass").getResource(this.colormaps::get)) != null) {
            this.colorCalculatorFactory.setGrassMap(grass);
        }
    }

    private Set<Key> collectUsedTextureKeys() {
        HashSet<Key> usedTextures = new HashSet<Key>();
        usedTextures.add(MISSING_TEXTURE);
        for (Model model : this.models.values()) {
            for (TextureVariable textureVariable : model.getTextures().values()) {
                if (textureVariable.isReference()) continue;
                usedTextures.add(textureVariable.getTexturePath());
            }
        }
        for (ResourcePackExtension extension : this.extensions.values()) {
            usedTextures.addAll(extension.collectUsedTextureKeys());
        }
        return usedTextures;
    }

    private Atlas getBlocksAtlas() {
        Atlas blocksAtlas = this.atlases.get(BLOCKS_ATLAS);
        if (blocksAtlas != null) {
            return blocksAtlas;
        }
        Logger.global.noFloodWarning("blocks-atlas-missing", "Atlas " + String.valueOf(BLOCKS_ATLAS) + " is missing or got accessed before loaded!");
        return new Atlas();
    }

    public BlockProperties getBlockProperties(de.bluecolored.bluemap.core.world.BlockState state) {
        return this.blockPropertiesCache.get(state);
    }

    private BlockProperties loadBlockProperties(de.bluecolored.bluemap.core.world.BlockState state) {
        BlockState resource;
        BlockProperties.Builder props = this.blockPropertiesConfig.getBlockProperties(state).toBuilder();
        if ((props.isOccluding() == Tristate.UNDEFINED || props.isCulling() == Tristate.UNDEFINED) && (resource = this.blockStates.get(state.getId())) != null) {
            resource.forEach(state, 0, 0, 0, variant -> {
                Model model = variant.getModel().getResource(this.models::get);
                if (model != null) {
                    if (props.isOccluding() == Tristate.UNDEFINED) {
                        props.occluding(model.isOccluding());
                    }
                    if (props.isCulling() == Tristate.UNDEFINED) {
                        props.culling(model.isCulling());
                    }
                }
            });
        }
        return props.build();
    }

    public <T extends ResourcePackExtension> T getExtension(Extension<T> extensionType) {
        return (T)this.extensions.get(extensionType);
    }

    public ResourcePool<Atlas> getAtlases() {
        return this.atlases;
    }

    public ResourcePool<BlockState> getBlockStates() {
        return this.blockStates;
    }

    public ResourcePool<EntityState> getEntityStates() {
        return this.entityStates;
    }

    public ResourcePool<Model> getModels() {
        return this.models;
    }

    public ResourcePool<Texture> getTextures() {
        return this.textures;
    }

    public ResourcePool<BufferedImage> getColormaps() {
        return this.colormaps;
    }

    public BlockColorCalculatorFactory getColorCalculatorFactory() {
        return this.colorCalculatorFactory;
    }

    public static interface Extension<T extends ResourcePackExtension>
    extends Keyed {
        public static final Registry<Extension<?>> REGISTRY = new Registry();

        public T create(ResourcePack var1);
    }
}

