/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.resources.pack;

import com.google.gson.Gson;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import de.bluecolored.bluemap.core.resources.adapter.AbstractTypeAdapterFactory;
import de.bluecolored.bluemap.core.resources.pack.PackVersion;
import de.bluecolored.bluemap.core.util.Key;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class PackMeta {
    private Pack pack = new Pack();
    private Overlays overlays = new Overlays();
    private Features features = new Features();

    public Pack getPack() {
        return this.pack;
    }

    public Overlays getOverlays() {
        return this.overlays;
    }

    public Features getFeatures() {
        return this.features;
    }

    public static class Pack {
        @JsonAdapter(value=PackVersion.MinAdapter.class)
        private PackVersion minFormat;
        @JsonAdapter(value=PackVersion.MaxAdapter.class)
        private PackVersion maxFormat;
        private VersionRange packFormat = new VersionRange();
        @Nullable
        private VersionRange supportedFormats;

        public boolean includes(PackVersion version) {
            if (this.minFormat == null || this.maxFormat == null) {
                if (this.supportedFormats != null && this.supportedFormats.includes(version.getMajor())) {
                    return true;
                }
                return this.packFormat.includes(version.getMajor());
            }
            return version.isGreaterOrEqual(this.minFormat) && version.isSmallerOrEqual(this.maxFormat);
        }

        public PackVersion getMinFormat() {
            return this.minFormat;
        }

        public PackVersion getMaxFormat() {
            return this.maxFormat;
        }

        public VersionRange getPackFormat() {
            return this.packFormat;
        }

        @Nullable
        public VersionRange getSupportedFormats() {
            return this.supportedFormats;
        }
    }

    public static class Overlays {
        private Overlay[] entries = new Overlay[0];

        public Overlay[] getEntries() {
            return this.entries;
        }
    }

    public static class Features {
        private Collection<Key> enabled = Set.of();

        public Collection<Key> getEnabled() {
            return this.enabled;
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static class VersionRange {
        private int minInclusive = Integer.MIN_VALUE;
        private int maxInclusive = Integer.MAX_VALUE;

        public boolean includes(int version) {
            return version >= this.minInclusive && version <= this.maxInclusive;
        }

        public int getMinInclusive() {
            return this.minInclusive;
        }

        public int getMaxInclusive() {
            return this.maxInclusive;
        }

        public VersionRange() {
        }

        public VersionRange(int minInclusive, int maxInclusive) {
            this.minInclusive = minInclusive;
            this.maxInclusive = maxInclusive;
        }

        private static class Adapter
        extends AbstractTypeAdapterFactory<VersionRange> {
            public Adapter() {
                super(VersionRange.class);
            }

            @Override
            public VersionRange read(JsonReader in, Gson gson) throws IOException {
                return switch (in.peek()) {
                    case JsonToken.NUMBER -> {
                        int version = in.nextInt();
                        yield new VersionRange(version, version);
                    }
                    case JsonToken.BEGIN_ARRAY -> {
                        in.beginArray();
                        VersionRange range = new VersionRange(in.nextInt(), in.nextInt());
                        while (in.peek() != JsonToken.END_ARRAY) {
                            in.skipValue();
                        }
                        in.endArray();
                        yield range;
                    }
                    default -> (VersionRange)gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(VersionRange.class)).read(in);
                };
            }
        }
    }

    public static class Overlay {
        @JsonAdapter(value=PackVersion.MinAdapter.class)
        private PackVersion minFormat;
        @JsonAdapter(value=PackVersion.MaxAdapter.class)
        private PackVersion maxFormat;
        @Nullable
        private String directory;
        private VersionRange formats = new VersionRange();

        public boolean includes(PackVersion version) {
            if (this.minFormat == null || this.maxFormat == null) {
                return this.formats.includes(version.getMajor());
            }
            return version.isGreaterOrEqual(this.minFormat) && version.isSmallerOrEqual(this.maxFormat);
        }

        public PackVersion getMinFormat() {
            return this.minFormat;
        }

        public PackVersion getMaxFormat() {
            return this.maxFormat;
        }

        @Nullable
        public String getDirectory() {
            return this.directory;
        }

        public VersionRange getFormats() {
            return this.formats;
        }
    }
}

