/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.resources.adapter;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import de.bluecolored.bluemap.core.resources.adapter.PostDeserialize;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class PostDeserializeAdapterFactory
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        for (final Method method : type.getRawType().getDeclaredMethods()) {
            if (!method.isAnnotationPresent(PostDeserialize.class) || method.getParameterCount() != 0) continue;
            final TypeAdapter delegate = gson.getDelegateAdapter((TypeAdapterFactory)this, type);
            return new TypeAdapter<T>(this){

                public void write(JsonWriter out, T value) throws IOException {
                    delegate.write(out, value);
                }

                public T read(JsonReader in) throws IOException {
                    try {
                        Object obj = delegate.read(in);
                        method.setAccessible(true);
                        method.invoke(obj, new Object[0]);
                        return obj;
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        throw new IOException(e);
                    }
                }
            };
        }
        return null;
    }
}

